/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.grpc.ClientVersionClientInjector;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public class ClientContextServerInjector
implements ServerInterceptor {
    private static final ThreadLocal<String> IP_ADDRESS_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> CLIENT_VERSION_THREAD_LOCAL = new ThreadLocal();

    @Nullable
    public static String getIpAddress() {
        return IP_ADDRESS_THREAD_LOCAL.get();
    }

    @Nullable
    public static String getClientVersion() {
        return CLIENT_VERSION_THREAD_LOCAL.get();
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.setRemoteIpAddress(call);
        this.setClientVersion(headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            public void onHalfClose() {
                ClientContextServerInjector.this.setRemoteIpAddress(call);
                ClientContextServerInjector.this.setClientVersion(headers);
                super.onHalfClose();
            }
        };
    }

    private <ReqT, RespT> void setRemoteIpAddress(ServerCall<ReqT, RespT> call) {
        String remoteIpAddress = ((SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).toString();
        IP_ADDRESS_THREAD_LOCAL.set(remoteIpAddress);
    }

    private void setClientVersion(Metadata headers) {
        String version = (String)headers.get(ClientVersionClientInjector.S_CLIENT_VERSION_KEY);
        CLIENT_VERSION_THREAD_LOCAL.set(version);
    }
}

