/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.grpc.PMode;
import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclActions;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public final class Mode {
    private Bits mOwnerBits;
    private Bits mGroupBits;
    private Bits mOtherBits;

    public static Mode defaults() {
        return new Mode(511);
    }

    public static Mode createNoAccess() {
        return new Mode();
    }

    public static Mode createFullAccess() {
        return new Mode(Bits.ALL, Bits.ALL, Bits.ALL);
    }

    private Mode() {
        this.mOwnerBits = Bits.NONE;
        this.mGroupBits = Bits.NONE;
        this.mOtherBits = Bits.NONE;
    }

    public Mode(Bits ownerBits, Bits groupBits, Bits otherBits) {
        this.set(ownerBits, groupBits, otherBits);
    }

    public Mode(short mode) {
        this.fromShort(mode);
    }

    public Mode(Mode mode) {
        this.set(mode.mOwnerBits, mode.mGroupBits, mode.mOtherBits);
    }

    public static Mode and(Mode mode1, Mode mode2) {
        Bits u = mode1.mOwnerBits.and(mode2.mOwnerBits);
        Bits g = mode1.mGroupBits.and(mode2.mGroupBits);
        Bits o = mode1.mOtherBits.and(mode2.mOtherBits);
        return new Mode(u, g, o);
    }

    public Bits getOwnerBits() {
        return this.mOwnerBits;
    }

    public static Bits extractOwnerBits(short mode) {
        return Bits.values()[mode >>> 6 & 7];
    }

    public void setOwnerBits(Bits bits) {
        this.mOwnerBits = bits;
    }

    public Bits getGroupBits() {
        return this.mGroupBits;
    }

    public static Bits extractGroupBits(short mode) {
        return Bits.values()[mode >>> 3 & 7];
    }

    public void setGroupBits(Bits bits) {
        this.mGroupBits = bits;
    }

    public Bits getOtherBits() {
        return this.mOtherBits;
    }

    public static Bits extractOtherBits(short mode) {
        return Bits.values()[mode & 7];
    }

    public void setOtherBits(Bits bits) {
        this.mOtherBits = bits;
    }

    private void set(Bits u, Bits g, Bits o) {
        this.mOwnerBits = u;
        this.mGroupBits = g;
        this.mOtherBits = o;
    }

    public void fromShort(short n) {
        Bits[] v = Bits.values();
        this.set(v[n >>> 6 & 7], v[n >>> 3 & 7], v[n & 7]);
    }

    public short toShort() {
        int s = this.mOwnerBits.ordinal() << 6 | this.mGroupBits.ordinal() << 3 | this.mOtherBits.ordinal();
        return (short)s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Mode) {
            Mode that = (Mode)obj;
            return this.mOwnerBits == that.mOwnerBits && this.mGroupBits == that.mGroupBits && this.mOtherBits == that.mOtherBits;
        }
        return false;
    }

    public int hashCode() {
        return this.toShort();
    }

    public String toString() {
        return this.mOwnerBits.toString() + this.mGroupBits.toString() + this.mOtherBits.toString();
    }

    public static Mode fromProto(PMode pMode) {
        Bits ownerBits = pMode.hasOwnerBits() ? Bits.valueOf(pMode.getOwnerBits().name()) : Bits.NONE;
        Bits groupBits = pMode.hasGroupBits() ? Bits.valueOf(pMode.getGroupBits().name()) : Bits.NONE;
        Bits otherBits = pMode.hasOtherBits() ? Bits.valueOf(pMode.getOtherBits().name()) : Bits.NONE;
        return new Mode(ownerBits, groupBits, otherBits);
    }

    public PMode toProto() {
        return PMode.newBuilder().setOwnerBits(alluxio.grpc.Bits.valueOf((String)this.mOwnerBits.name())).setGroupBits(alluxio.grpc.Bits.valueOf((String)this.mGroupBits.name())).setOtherBits(alluxio.grpc.Bits.valueOf((String)this.mOtherBits.name())).build();
    }

    @ThreadSafe
    public static enum Bits {
        NONE("---"),
        EXECUTE("--x"),
        WRITE("-w-"),
        WRITE_EXECUTE("-wx"),
        READ("r--"),
        READ_EXECUTE("r-x"),
        READ_WRITE("rw-"),
        ALL("rwx");

        private final String mString;
        private static final Bits[] SVALS;

        private Bits(String s) {
            this.mString = s;
        }

        public static Bits fromShort(short bits) {
            return SVALS[bits];
        }

        public static Bits fromString(String string) {
            switch (string) {
                case "---": {
                    return NONE;
                }
                case "--x": {
                    return EXECUTE;
                }
                case "-w-": {
                    return WRITE;
                }
                case "-wx": {
                    return WRITE_EXECUTE;
                }
                case "r--": {
                    return READ;
                }
                case "r-x": {
                    return READ_EXECUTE;
                }
                case "rw-": {
                    return READ_WRITE;
                }
                case "rwx": {
                    return ALL;
                }
            }
            throw new IllegalArgumentException("Invalid mode string: " + string);
        }

        public static Bits fromProto(alluxio.grpc.Bits protoBits) {
            return Bits.valueOf(protoBits.name());
        }

        public alluxio.grpc.Bits toProto() {
            return alluxio.grpc.Bits.valueOf((String)this.name());
        }

        public String toString() {
            return this.mString;
        }

        public boolean imply(Bits that) {
            if (that != null) {
                return (this.ordinal() & that.ordinal()) == that.ordinal();
            }
            return false;
        }

        public Bits and(Bits that) {
            Preconditions.checkNotNull((Object)((Object)that), (Object)"that");
            return SVALS[this.ordinal() & that.ordinal()];
        }

        public Bits or(Bits that) {
            Preconditions.checkNotNull((Object)((Object)that), (Object)"that");
            return SVALS[this.ordinal() | that.ordinal()];
        }

        public Bits not() {
            return SVALS[7 - this.ordinal()];
        }

        public Set<AclAction> toAclActionSet() {
            HashSet<AclAction> actions = new HashSet<AclAction>();
            if (this.imply(READ)) {
                actions.add(AclAction.READ);
            }
            if (this.imply(WRITE)) {
                actions.add(AclAction.WRITE);
            }
            if (this.imply(EXECUTE)) {
                actions.add(AclAction.EXECUTE);
            }
            return actions;
        }

        public AclActions toAclActions() {
            AclActions actions = new AclActions();
            if (this.imply(READ)) {
                actions.add(AclAction.READ);
            }
            if (this.imply(WRITE)) {
                actions.add(AclAction.WRITE);
            }
            if (this.imply(EXECUTE)) {
                actions.add(AclAction.EXECUTE);
            }
            return actions;
        }

        static {
            SVALS = Bits.values();
        }
    }
}

