/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class MultiRangeObjectInputStream
extends InputStream {
    protected boolean mClosed;
    protected InputStream mStream;
    protected long mPos;
    protected long mEndPos;
    private final long mMultiRangeChunkSize;

    protected MultiRangeObjectInputStream(long multiRangeChunkSize) {
        this.mMultiRangeChunkSize = multiRangeChunkSize;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.closeStream();
        }
        this.mClosed = true;
    }

    @Override
    public int read() throws IOException {
        this.openStream();
        int value = this.mStream.read();
        if (value != -1) {
            ++this.mPos;
            this.closeStreamIfBoundary();
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        this.openStream();
        int read = this.mStream.read(b, offset, length);
        if (read != -1) {
            this.mPos += (long)read;
            this.closeStreamIfBoundary();
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.closeStream();
        this.mPos += n;
        this.openStream();
        return n;
    }

    private void closeStreamIfBoundary() throws IOException {
        if (this.mPos >= this.mEndPos) {
            this.closeStream();
        }
    }

    private void closeStream() throws IOException {
        if (this.mStream == null) {
            return;
        }
        this.mStream.close();
        this.mStream = null;
    }

    protected abstract InputStream createStream(long var1, long var3) throws IOException;

    private void openStream() throws IOException {
        long endPos;
        if (this.mClosed) {
            throw new IOException("Stream closed");
        }
        if (this.mMultiRangeChunkSize <= 0L) {
            throw new IOException(MessageFormat.format("Block size of {0} is invalid. Block size must be > 0 bytes.", this.mMultiRangeChunkSize));
        }
        if (this.mStream != null) {
            return;
        }
        this.mEndPos = endPos = this.mPos + this.mMultiRangeChunkSize - this.mPos % this.mMultiRangeChunkSize;
        this.mStream = this.createStream(this.mPos, endPos);
    }
}

