/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.extensions.ExtensionFactoryRegistry;
import alluxio.recorder.Recorder;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class UnderFileSystemFactoryRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UnderFileSystemFactoryRegistry.class);
    private static final String UFS_EXTENSION_PATTERN = "alluxio-underfs-*.jar";
    private static ExtensionFactoryRegistry<UnderFileSystemFactory, UnderFileSystemConfiguration> sRegistryInstance;

    private UnderFileSystemFactoryRegistry() {
    }

    public static List<UnderFileSystemFactory> available() {
        return sRegistryInstance.getAvailable();
    }

    @Nullable
    public static UnderFileSystemFactory find(String path, AlluxioConfiguration alluxioConf) {
        return UnderFileSystemFactoryRegistry.find(path, UnderFileSystemConfiguration.defaults(alluxioConf));
    }

    @Nullable
    public static UnderFileSystemFactory find(String path, UnderFileSystemConfiguration ufsConf) {
        List<UnderFileSystemFactory> factories = UnderFileSystemFactoryRegistry.findAllWithRecorder(path, ufsConf, Recorder.noopRecorder());
        if (factories.isEmpty()) {
            LOG.warn("No Under File System Factory implementation supports the path {}. Please check if the under storage path is valid.", (Object)path);
            return null;
        }
        LOG.debug("Selected Under File System Factory implementation {} for path {}", factories.get(0).getClass(), (Object)path);
        return factories.get(0);
    }

    public static List<UnderFileSystemFactory> findAllWithRecorder(String path, UnderFileSystemConfiguration ufsConf, Recorder recorder) {
        List<UnderFileSystemFactory> eligibleFactories = sRegistryInstance.findAllWithRecorder(path, ufsConf, recorder);
        if (eligibleFactories.isEmpty() && ufsConf.isSet(PropertyKey.UNDERFS_VERSION)) {
            String configuredVersion = ufsConf.getString(PropertyKey.UNDERFS_VERSION);
            List<String> supportedVersions = UnderFileSystemFactoryRegistry.getSupportedVersions(path, ufsConf);
            if (!supportedVersions.isEmpty()) {
                String message = String.format("Versions [%s] are supported for path %s but you have configured version: %s", StringUtils.join(supportedVersions, (String)","), path, configuredVersion);
                recorder.record(message);
                LOG.warn(message);
            }
        } else if (ufsConf.getBoolean(PropertyKey.UNDERFS_STRICT_VERSION_MATCH_ENABLED) && !eligibleFactories.isEmpty() && ufsConf.isSet(PropertyKey.UNDERFS_VERSION)) {
            String configuredVersion = ufsConf.getString(PropertyKey.UNDERFS_VERSION);
            Iterator<UnderFileSystemFactory> it = eligibleFactories.iterator();
            while (it.hasNext()) {
                if (configuredVersion.equals(it.next().getVersion())) continue;
                it.remove();
            }
        }
        return eligibleFactories;
    }

    public static List<String> getSupportedVersions(String path, AlluxioConfiguration ufsConf) {
        InstancedConfiguration confCopy = new InstancedConfiguration(ufsConf.copyProperties());
        confCopy.unset(PropertyKey.UNDERFS_VERSION);
        List<UnderFileSystemFactory> factories = sRegistryInstance.findAllWithRecorder(path, UnderFileSystemConfiguration.defaults(confCopy), new Recorder());
        ArrayList<String> supportedVersions = new ArrayList<String>();
        for (UnderFileSystemFactory factory : factories) {
            if (factory.getVersion().isEmpty()) continue;
            supportedVersions.add(factory.getVersion());
        }
        return supportedVersions;
    }

    private static synchronized void init() {
        if (sRegistryInstance == null) {
            sRegistryInstance = new ExtensionFactoryRegistry(UnderFileSystemFactory.class, UFS_EXTENSION_PATTERN);
        }
    }

    public static void register(UnderFileSystemFactory factory) {
        sRegistryInstance.register(factory);
    }

    public static synchronized void reset() {
        sRegistryInstance.reset();
    }

    public static void unregister(UnderFileSystemFactory factory) {
        sRegistryInstance.unregister(factory);
    }

    static {
        UnderFileSystemFactoryRegistry.init();
    }
}

