/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Map;

public interface JsonSerializable {
    public static final String CLASS_NAME_FIELD = "className";

    default public String getClassName() {
        return this.getClass().getName();
    }

    default public void setClassName(String className) {
    }

    default public String toJson() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public static JsonSerializable fromJson(String json) throws IOException, ClassNotFoundException {
        ObjectMapper mapper = new ObjectMapper();
        MapType type = mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        Map data = (Map)mapper.readValue(json, (JavaType)type);
        if (!data.containsKey(CLASS_NAME_FIELD)) {
            throw new IOException("Json data does not contain field: className");
        }
        Class<?> clazz = Class.forName(data.get(CLASS_NAME_FIELD).toString());
        return (JsonSerializable)mapper.readValue(json, clazz);
    }

    public static <T extends JsonSerializable> T fromJson(String json, T[] types) throws IOException, ClassNotFoundException {
        return (T)JsonSerializable.fromJson(json);
    }
}

