/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.webui;

import alluxio.util.FormatUtils;

public final class StorageTierInfo {
    private final String mStorageTierAlias;
    private final long mCapacityBytes;
    private final long mUsedBytes;
    private final int mUsedPercent;
    private final long mFreeBytes;
    private final int mFreePercent;

    public StorageTierInfo(String storageTierAlias, long capacityBytes, long usedBytes) {
        this.mStorageTierAlias = storageTierAlias;
        this.mCapacityBytes = capacityBytes;
        this.mUsedBytes = usedBytes;
        this.mFreeBytes = this.mCapacityBytes - this.mUsedBytes;
        this.mUsedPercent = (int)(100L * this.mUsedBytes / this.mCapacityBytes);
        this.mFreePercent = 100 - this.mUsedPercent;
    }

    public String getStorageTierAlias() {
        return this.mStorageTierAlias;
    }

    public String getCapacity() {
        return FormatUtils.getSizeFromBytes(this.mCapacityBytes);
    }

    public String getFreeCapacity() {
        return FormatUtils.getSizeFromBytes(this.mFreeBytes);
    }

    public int getFreeSpacePercent() {
        return this.mFreePercent;
    }

    public String getUsedCapacity() {
        return FormatUtils.getSizeFromBytes(this.mUsedBytes);
    }

    public int getUsedSpacePercent() {
        return this.mUsedPercent;
    }
}

