/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SpecificHostPolicy
implements BlockLocationPolicy {
    private final String mHostname;
    @Nullable
    private final Integer mRpcPort;

    public SpecificHostPolicy(AlluxioConfiguration conf) {
        this(conf.getString(PropertyKey.WORKER_HOSTNAME), conf.getInt(PropertyKey.WORKER_RPC_PORT));
    }

    public SpecificHostPolicy(String hostname) {
        this(hostname, null);
    }

    public SpecificHostPolicy(String hostname, @Nullable Integer rpcPort) {
        this.mHostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
        this.mRpcPort = rpcPort;
    }

    @Override
    public Optional<WorkerNetAddress> getWorker(GetWorkerOptions options) {
        for (BlockWorkerInfo info : options.getBlockWorkerInfos()) {
            if (!info.getNetAddress().getHost().equals(this.mHostname) || this.mRpcPort != null && info.getNetAddress().getRpcPort() != this.mRpcPort.intValue()) continue;
            return Optional.of(info.getNetAddress());
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecificHostPolicy)) {
            return false;
        }
        SpecificHostPolicy that = (SpecificHostPolicy)o;
        return Objects.equal((Object)this.mHostname, (Object)that.mHostname);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mHostname});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hostname", (Object)this.mHostname).toString();
    }
}

