/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheScope;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PageInfo {
    private final PageId mPageId;
    private final long mPageSize;
    private final CacheScope mCacheScope;
    private final PageStoreDir mLocalCacheDir;
    private final long mCreatedTimestamp;

    public PageInfo(PageId pageId, long pageSize, PageStoreDir pageStoreDir) {
        this(pageId, pageSize, CacheScope.GLOBAL, pageStoreDir);
    }

    public PageInfo(PageId pageId, long pageSize, CacheScope cacheScope, PageStoreDir pageStoreDir) {
        this(pageId, pageSize, cacheScope, pageStoreDir, System.currentTimeMillis());
    }

    public PageInfo(PageId pageId, long pageSize, CacheScope cacheScope, PageStoreDir pageStoreDir, long createdTimestamp) {
        this.mPageId = pageId;
        this.mPageSize = pageSize;
        this.mCacheScope = cacheScope;
        this.mLocalCacheDir = pageStoreDir;
        this.mCreatedTimestamp = createdTimestamp;
    }

    public PageId getPageId() {
        return this.mPageId;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public CacheScope getScope() {
        return this.mCacheScope;
    }

    public PageStoreDir getLocalCacheDir() {
        return this.mLocalCacheDir;
    }

    public long getCreatedTimestamp() {
        return this.mCreatedTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageInfo pageInfo = (PageInfo)o;
        return this.mPageSize == pageInfo.mPageSize && Objects.equals(this.mPageId, pageInfo.mPageId) && this.mCacheScope == pageInfo.mCacheScope;
    }

    public int hashCode() {
        return Objects.hash(this.mPageId, this.mPageSize, this.mCacheScope);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("PageId", (Object)this.mPageId).add("PageSize", this.mPageSize).add("Scope", (Object)this.mCacheScope).add("CreateTimeMs", this.mCreatedTimestamp).toString();
    }
}

