/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.ClockCuckooShadowCacheManager;
import alluxio.client.file.cache.MultipleBloomShadowCacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.ShadowCacheType;
import alluxio.client.quota.CacheScope;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;

public interface ShadowCacheManager {
    public static ShadowCacheManager create(AlluxioConfiguration conf) {
        ShadowCacheType shadowCacheType = (ShadowCacheType)conf.getEnum(PropertyKey.USER_CLIENT_CACHE_SHADOW_TYPE, ShadowCacheType.class);
        switch (shadowCacheType) {
            case CLOCK_CUCKOO_FILTER: {
                return new ClockCuckooShadowCacheManager(conf);
            }
        }
        return new MultipleBloomShadowCacheManager(conf);
    }

    public boolean put(PageId var1, int var2, CacheScope var3);

    public int get(PageId var1, int var2, CacheScope var3);

    public boolean delete(PageId var1);

    public void aging();

    public void updateWorkingSetSize();

    public void stopUpdate();

    public long getShadowCachePages();

    public long getShadowCachePages(CacheScope var1);

    public long getShadowCacheBytes();

    public long getShadowCacheBytes(CacheScope var1);

    public long getShadowCachePageRead();

    public long getShadowCachePageHit();

    public long getShadowCacheByteRead();

    public long getShadowCacheByteHit();

    public double getFalsePositiveRatio();
}

