/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.store.PageStoreType;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.FormatUtils;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class PageStoreOptions {
    private PageStoreType mStoreType = PageStoreType.LOCAL;
    private int mFileBuckets = 1000;
    private Path mRootDir;
    private int mIndex;
    private long mPageSize;
    private long mCacheSize;
    private String mAlluxioVersion;
    private long mTimeoutDuration;
    private int mTimeoutThreads;
    private double mOverheadRatio;

    public static List<PageStoreOptions> create(AlluxioConfiguration conf) {
        List dirs = conf.getList(PropertyKey.USER_CLIENT_CACHE_DIRS);
        List cacheSizes = conf.getList(PropertyKey.USER_CLIENT_CACHE_SIZE);
        PageStoreType storeType = (PageStoreType)conf.getEnum(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, PageStoreType.class);
        List<PageStoreOptions> optionsList = PageStoreOptions.createPageStoreOptions(dirs, cacheSizes, storeType);
        optionsList.forEach(options -> {
            options.setFileBuckets(conf.getInt(PropertyKey.USER_CLIENT_CACHE_LOCAL_STORE_FILE_BUCKETS)).setPageSize(conf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE)).setAlluxioVersion(conf.getString(PropertyKey.VERSION)).setTimeoutDuration(conf.getMs(PropertyKey.USER_CLIENT_CACHE_TIMEOUT_DURATION)).setTimeoutThreads(conf.getInt(PropertyKey.USER_CLIENT_CACHE_TIMEOUT_THREADS));
            if (conf.isSet(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD)) {
                options.setOverheadRatio(conf.getDouble(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD));
            }
        });
        return optionsList;
    }

    public static List<PageStoreOptions> createForWorkerPageStore(AlluxioConfiguration conf) {
        List dirs = conf.getList(PropertyKey.WORKER_PAGE_STORE_DIRS);
        List cacheSizes = conf.getList(PropertyKey.WORKER_PAGE_STORE_SIZES);
        PageStoreType storeType = (PageStoreType)conf.getEnum(PropertyKey.WORKER_PAGE_STORE_TYPE, PageStoreType.class);
        List<PageStoreOptions> optionsList = PageStoreOptions.createPageStoreOptions(dirs, cacheSizes, storeType);
        optionsList.forEach(options -> {
            options.setFileBuckets(conf.getInt(PropertyKey.WORKER_PAGE_STORE_LOCAL_STORE_FILE_BUCKETS)).setPageSize(conf.getBytes(PropertyKey.WORKER_PAGE_STORE_PAGE_SIZE)).setAlluxioVersion(conf.getString(PropertyKey.VERSION)).setTimeoutDuration(conf.getMs(PropertyKey.WORKER_PAGE_STORE_TIMEOUT_DURATION)).setTimeoutThreads(conf.getInt(PropertyKey.WORKER_PAGE_STORE_TIMEOUT_THREADS));
            if (conf.isSet(PropertyKey.WORKER_PAGE_STORE_OVERHEAD)) {
                options.setOverheadRatio(conf.getDouble(PropertyKey.WORKER_PAGE_STORE_OVERHEAD));
            }
        });
        return optionsList;
    }

    private static List<PageStoreOptions> createPageStoreOptions(List<String> dirs, List<String> cacheSizes, PageStoreType storeType) {
        Preconditions.checkArgument((!dirs.isEmpty() ? 1 : 0) != 0, (Object)"Cache dirs is empty");
        Preconditions.checkArgument((!cacheSizes.isEmpty() ? 1 : 0) != 0, (Object)"Cache cacheSizes is empty");
        Preconditions.checkArgument((dirs.size() == cacheSizes.size() ? 1 : 0) != 0, (Object)"The number of dirs does not match the number of cacheSizes");
        ArrayList<PageStoreOptions> optionsList = new ArrayList<PageStoreOptions>(dirs.size());
        for (int i = 0; i < dirs.size(); ++i) {
            PageStoreOptions options = new PageStoreOptions();
            options.setRootDir(Paths.get(dirs.get(i), storeType.name())).setCacheSize(FormatUtils.parseSpaceSize((String)cacheSizes.get(i))).setStoreType(storeType).setOverheadRatio(storeType.getOverheadRatio()).setIndex(i);
            optionsList.add(options);
        }
        return optionsList;
    }

    public PageStoreType getType() {
        return this.mStoreType;
    }

    public PageStoreOptions setRootDir(Path rootDir) {
        this.mRootDir = rootDir;
        return this;
    }

    public Path getRootDir() {
        return this.mRootDir;
    }

    public PageStoreOptions setIndex(int index) {
        this.mIndex = index;
        return this;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public PageStoreOptions setPageSize(long pageSize) {
        this.mPageSize = pageSize;
        return this;
    }

    public long getCacheSize() {
        return this.mCacheSize;
    }

    public PageStoreOptions setCacheSize(long cacheSize) {
        this.mCacheSize = cacheSize;
        return this;
    }

    public String getAlluxioVersion() {
        return this.mAlluxioVersion;
    }

    public PageStoreOptions setAlluxioVersion(String alluxioVersion) {
        this.mAlluxioVersion = alluxioVersion;
        return this;
    }

    public long getTimeoutDuration() {
        return this.mTimeoutDuration;
    }

    public PageStoreOptions setTimeoutDuration(long timeout) {
        this.mTimeoutDuration = timeout;
        return this;
    }

    public int getTimeoutThreads() {
        return this.mTimeoutThreads;
    }

    public PageStoreOptions setTimeoutThreads(int threads) {
        this.mTimeoutThreads = threads;
        return this;
    }

    public double getOverheadRatio() {
        return this.mOverheadRatio;
    }

    public PageStoreOptions setOverheadRatio(double overheadRatio) {
        this.mOverheadRatio = overheadRatio;
        return this;
    }

    public PageStoreOptions setFileBuckets(int fileBuckets) {
        this.mFileBuckets = fileBuckets;
        return this;
    }

    public int getFileBuckets() {
        return this.mFileBuckets;
    }

    public PageStoreOptions setStoreType(PageStoreType storeType) {
        this.mStoreType = storeType;
        return this;
    }
}

