/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.ufs;

import alluxio.client.file.FileOutStream;
import alluxio.exception.PreconditionMessage;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class UfsFileOutStream
extends FileOutStream {
    private final Closer mCloser = Closer.create();
    private final OutputStream mUfsOutStream;

    public UfsFileOutStream(OutputStream stream) {
        this.mUfsOutStream = (OutputStream)Preconditions.checkNotNull((Object)stream);
        this.mCloser.register((Closeable)this.mUfsOutStream);
    }

    @Override
    public synchronized long getBytesWritten() {
        return this.mBytesWritten;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.mUfsOutStream.write(b);
        ++this.mBytesWritten;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        Preconditions.checkArgument((b != null ? 1 : 0) != 0, (Object)PreconditionMessage.ERR_WRITE_BUFFER_NULL);
        this.mUfsOutStream.write(b);
        this.mBytesWritten += (long)b.length;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument((off >= 0 && len >= 0 && len + off <= b.length ? 1 : 0) != 0, (String)PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)b.length, (Object)off, (Object)len);
        this.mUfsOutStream.write(b, off, len);
        this.mBytesWritten += (long)len;
    }

    @Override
    public synchronized void cancel() {
    }

    @Override
    public synchronized void close() throws IOException {
        this.mCloser.close();
    }
}

