/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class AccessPolicy
implements XmlSerializable<AccessPolicy> {
    private OffsetDateTime start;
    private OffsetDateTime expiry;
    private String permission;

    public OffsetDateTime getStart() {
        return this.start;
    }

    public AccessPolicy setStart(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    public OffsetDateTime getExpiry() {
        return this.expiry;
    }

    public AccessPolicy setExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public String getPermission() {
        return this.permission;
    }

    public AccessPolicy setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "AccessPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Start", this.start == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.start));
        xmlWriter.writeStringElement("Expiry", this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        xmlWriter.writeStringElement("Permission", this.permission);
        return xmlWriter.writeEndElement();
    }

    public static AccessPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return AccessPolicy.fromXml(xmlReader, null);
    }

    public static AccessPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "AccessPolicy" : rootElementName;
        return (AccessPolicy)xmlReader.readObject(finalRootElementName, reader -> {
            AccessPolicy deserializedAccessPolicy = new AccessPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedAccessPolicy.start = (OffsetDateTime)reader.getNullableElement(dateString -> OffsetDateTime.parse(dateString));
                    continue;
                }
                if ("Expiry".equals(elementName.getLocalPart())) {
                    deserializedAccessPolicy.expiry = (OffsetDateTime)reader.getNullableElement(dateString -> OffsetDateTime.parse(dateString));
                    continue;
                }
                if ("Permission".equals(elementName.getLocalPart())) {
                    deserializedAccessPolicy.permission = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedAccessPolicy;
        });
    }
}

