/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.implementation.models.SignedIdentifier;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SignedIdentifierWrapper
implements XmlSerializable<SignedIdentifierWrapper> {
    private final List<SignedIdentifier> signedIdentifiers;

    public SignedIdentifierWrapper(List<SignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    public List<SignedIdentifier> items() {
        return this.signedIdentifiers;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.signedIdentifiers != null) {
            for (SignedIdentifier element : this.signedIdentifiers) {
                xmlWriter.writeXml((XmlSerializable)element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static SignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SignedIdentifierWrapper.fromXml(xmlReader, null);
    }

    public static SignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        return (SignedIdentifierWrapper)xmlReader.readObject(rootElementName, reader -> {
            ArrayList<SignedIdentifier> items = null;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<SignedIdentifier>();
                    }
                    items.add(SignedIdentifier.fromXml(reader));
                    continue;
                }
                reader.nextElement();
            }
            return new SignedIdentifierWrapper(items);
        });
    }
}

