/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class ResettableFileInputStream
extends FilterInputStream {
    private final FileChannel myFileChannel;
    private long mark = -1L;

    public ResettableFileInputStream(FileInputStream fis) {
        super(fis);
        this.myFileChannel = fis.getChannel();
        this.mark(0);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int ignored) {
        try {
            this.mark = this.myFileChannel.position();
        }
        catch (IOException ex) {
            this.mark = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("not marked");
        }
        this.myFileChannel.position(this.mark);
    }
}

