/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.source;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.ingest.source.AbstractSourceInfo;
import java.util.Map;
import java.util.UUID;

public class BlobSourceInfo
extends AbstractSourceInfo {
    private String blobPath;
    private long rawSizeInBytes;

    public String getBlobPath() {
        return this.blobPath;
    }

    public void setBlobPath(String blobPath) {
        this.blobPath = blobPath;
    }

    public long getRawSizeInBytes() {
        return this.rawSizeInBytes;
    }

    public void setRawSizeInBytes(long rawSizeInBytes) {
        this.rawSizeInBytes = rawSizeInBytes;
    }

    public BlobSourceInfo(String blobPath) {
        this.blobPath = blobPath;
    }

    public BlobSourceInfo(String blobPath, long rawSizeInBytes) {
        this.blobPath = blobPath;
        this.rawSizeInBytes = rawSizeInBytes;
    }

    public BlobSourceInfo(String blobPath, long rawSizeInBytes, UUID sourceId) {
        this.blobPath = blobPath;
        this.rawSizeInBytes = rawSizeInBytes;
        this.setSourceId(sourceId);
    }

    @Override
    public void validate() {
        Ensure.stringIsNotBlank((String)this.blobPath, (String)"blobPath");
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        attributes.put("resource", this.blobPath);
        UUID sourceId = this.getSourceId();
        if (sourceId != null) {
            attributes.put("sourceId", sourceId.toString());
        }
        return attributes;
    }
}

