/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.source;

import com.microsoft.azure.kusto.ingest.source.AbstractSourceInfo;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class ResultSetSourceInfo
extends AbstractSourceInfo {
    private ResultSet resultSet;

    public ResultSetSourceInfo(ResultSet resultSet) {
        this.setResultSet(resultSet);
    }

    public ResultSetSourceInfo(ResultSet resultSet, UUID sourceId) {
        this.setResultSet(resultSet);
        this.setSourceId(sourceId);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = Objects.requireNonNull(resultSet, "ResultSet cannot be null");
    }

    public String toString() {
        return String.format("ResultSet with SourceId: %s", this.getSourceId());
    }

    @Override
    public void validate() {
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        attributes.put("resource", "resultSet");
        UUID sourceId = this.getSourceId();
        if (sourceId != null) {
            attributes.put("sourceId", sourceId.toString());
        }
        return attributes;
    }
}

