/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.commons.lang3.tuple.Pair;
import reactor.util.annotation.Nullable;

public class ClientDetails {
    public static final String NONE = "[none]";
    private static ConcurrentInitializer<String> defaultApplication = new LazyInitializer(){

        protected String initialize() {
            return UriUtils.stripFileNameFromCommandLine(System.getProperty("sun.java.command"));
        }
    };
    private static ConcurrentInitializer<String> defaultUser = new LazyInitializer(){

        protected String initialize() {
            String user = System.getProperty("user.name");
            if (StringUtils.isBlank((CharSequence)user)) {
                user = System.getenv("USERNAME");
                String domain = System.getenv("USERDOMAIN");
                if (StringUtils.isNotBlank((CharSequence)domain) && StringUtils.isNotBlank((CharSequence)user)) {
                    user = domain + "\\" + user;
                }
            }
            return StringUtils.isNotBlank((CharSequence)user) ? user : ClientDetails.NONE;
        }
    };
    private static ConcurrentInitializer<String> defaultVersion = new LazyInitializer(){

        protected String initialize() {
            return ClientDetails.formatHeader(Arrays.asList(Pair.of((Object)"Kusto.Java.Client", (Object)Utils.getPackageVersion()), Pair.of((Object)String.format("Runtime.%s", ClientDetails.escapeField(ClientDetails.getRuntime())), (Object)ClientDetails.getJavaVersion())));
        }
    };
    private String applicationForTracing;
    private String userNameForTracing;
    private String appendedClientVersionForTracing;

    public ClientDetails(String applicationForTracing, String userNameForTracing, String appendedClientVersionForTracing) {
        this.applicationForTracing = applicationForTracing;
        this.userNameForTracing = userNameForTracing;
        this.appendedClientVersionForTracing = appendedClientVersionForTracing;
    }

    private static String unpackLazy(ConcurrentInitializer<String> s) {
        try {
            return (String)s.get();
        }
        catch (ConcurrentException e) {
            return NONE;
        }
    }

    private static String formatHeader(Collection<Pair<String, String>> args) {
        return args.stream().filter(arg -> StringUtils.isNotBlank((CharSequence)((CharSequence)arg.getKey())) && StringUtils.isNotBlank((CharSequence)((CharSequence)arg.getValue()))).map(arg -> String.format("%s:%s", arg.getKey(), ClientDetails.escapeField((String)arg.getValue()))).collect(Collectors.joining("|"));
    }

    private static String escapeField(String field) {
        return String.format("{%s}", field.replaceAll("[\\r\\n\\s{}|]+", "_"));
    }

    public static ClientDetails fromConnectorDetails(String name, String version, boolean sendUser, @Nullable String overrideUser, @Nullable String appName, @Nullable String appVersion, Pair<String, String> ... additionalFields) {
        ArrayList<Pair<String, String>> additionalFieldsList = new ArrayList<Pair<String, String>>();
        additionalFieldsList.add(Pair.of((Object)("Kusto." + name), (Object)version));
        if (appName == null) {
            appName = ClientDetails.unpackLazy(defaultApplication);
        }
        if (appVersion == null) {
            appVersion = NONE;
        }
        additionalFieldsList.add(Pair.of((Object)String.format("App.%s", ClientDetails.escapeField(appName)), (Object)appVersion));
        if (additionalFields != null) {
            additionalFieldsList.addAll(Arrays.asList(additionalFields));
        }
        String app = ClientDetails.formatHeader(additionalFieldsList);
        String user = NONE;
        if (sendUser) {
            user = overrideUser != null ? overrideUser : ClientDetails.unpackLazy(defaultUser);
        }
        return new ClientDetails(app, user, null);
    }

    private static String getJavaVersion() {
        String version = System.getProperty("java.version");
        if (StringUtils.isBlank((CharSequence)version)) {
            return "UnknownVersion";
        }
        return version;
    }

    private static String getRuntime() {
        String runtime = System.getProperty("java.runtime.name");
        if (StringUtils.isBlank((CharSequence)runtime)) {
            runtime = System.getProperty("java.vm.name");
        }
        if (StringUtils.isBlank((CharSequence)runtime)) {
            runtime = System.getProperty("java.vendor");
        }
        if (StringUtils.isBlank((CharSequence)runtime)) {
            runtime = "UnknownRuntime";
        }
        return runtime;
    }

    public String getApplicationForTracing() {
        return this.applicationForTracing == null ? ClientDetails.unpackLazy(defaultApplication) : this.applicationForTracing;
    }

    public String getUserNameForTracing() {
        return this.userNameForTracing == null ? ClientDetails.unpackLazy(defaultUser) : this.userNameForTracing;
    }

    public String getClientVersionForTracing() {
        return ClientDetails.unpackLazy(defaultVersion) + (this.appendedClientVersionForTracing == null ? "" : "|" + this.appendedClientVersionForTracing);
    }
}

