/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class UriUtils {
    private UriUtils() {
    }

    public static String setPathForUri(String uri, String path, boolean ensureTrailingSlash) throws URISyntaxException {
        path = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String pathString = new URIBuilder(uri).setPath(path).build().toString();
        if (ensureTrailingSlash) {
            pathString = StringUtils.appendIfMissing((String)pathString, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return pathString;
    }

    public static String setPathForUri(String uri, String path) throws URISyntaxException {
        return UriUtils.setPathForUri(uri, path, false);
    }

    public static String appendPathToUri(String uri, String path) throws URISyntaxException {
        String existing = new URIBuilder(uri).getPath();
        return UriUtils.setPathForUri(uri, StringUtils.appendIfMissing((String)(existing == null ? "" : existing), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + path);
    }

    public static boolean isLocalAddress(String host) {
        if (host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || host.equals("[::1]")) {
            return true;
        }
        if (host.startsWith("127.") && host.length() <= 15 && host.length() >= 9) {
            for (int i = 0; i < host.length(); ++i) {
                char c = host.charAt(i);
                if (c == '.' || c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastDirSeparator = filename.lastIndexOf(File.separatorChar);
        if (extensionPos == -1 || lastDirSeparator > extensionPos) {
            return filename;
        }
        return filename.substring(lastDirSeparator + 1, extensionPos);
    }

    public static String[] getSasAndEndpointFromResourceURL(String url) throws URISyntaxException {
        String[] parts = url.split("\\?");
        if (parts.length != 2) {
            throw new URISyntaxException(url, "URL is missing the required SAS query");
        }
        return parts;
    }

    public static String stripFileNameFromCommandLine(String cmdLine) {
        try {
            String processNameForTracing = cmdLine;
            if (processNameForTracing != null) {
                processNameForTracing = Paths.get(processNameForTracing.trim().split(" ")[0], new String[0]).getFileName().toString();
            }
            return processNameForTracing;
        }
        catch (Exception e) {
            return null;
        }
    }
}

