/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.company;

import io.codearte.jfairy.data.DataMaster;
import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.VATIdentificationNumberProvider;
import io.codearte.jfairy.producer.company.Company;
import io.codearte.jfairy.producer.company.CompanyProperties;
import io.codearte.jfairy.producer.company.CompanyProvider;
import io.codearte.jfairy.producer.util.TextUtils;
import javax.inject.Inject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultCompanyProvider
implements CompanyProvider {
    protected String name;
    protected String domain;
    protected String email;
    protected String vatIdentificationNumber;
    protected BaseProducer baseProducer;
    protected DataMaster dataMaster;
    protected VATIdentificationNumberProvider vatIdentificationNumberProvider;

    @Inject
    public DefaultCompanyProvider(BaseProducer baseProducer, DataMaster dataMaster, VATIdentificationNumberProvider vatIdentificationNumberProvider, CompanyProperties.CompanyProperty ... companyProperties) {
        this.baseProducer = baseProducer;
        this.dataMaster = dataMaster;
        this.vatIdentificationNumberProvider = vatIdentificationNumberProvider;
        for (CompanyProperties.CompanyProperty companyProperty : companyProperties) {
            companyProperty.apply(this);
        }
    }

    @Override
    public Company get() {
        this.generateName();
        this.generateDomain();
        this.generateEmail();
        this.generateVatIdentificationNumber();
        return new Company(this.name, this.domain, this.email, this.vatIdentificationNumber);
    }

    @Override
    public void generateName() {
        if (this.name != null) {
            return;
        }
        this.name = this.dataMaster.getRandomValue("companyNames");
        if (this.baseProducer.trueOrFalse()) {
            this.name = this.name + " " + this.dataMaster.getRandomValue("companySuffixes");
        }
    }

    @Override
    public void generateDomain() {
        if (this.domain != null) {
            return;
        }
        String host = TextUtils.stripAccents(StringUtils.strip((String)StringUtils.deleteWhitespace((String)this.name.toLowerCase()), (String)".").replace("/", ""));
        int len1 = host.length();
        int len2 = (host = StringEscapeUtils.escapeJava((String)host).replaceAll("\\\\u", "")).length();
        if (len2 > len1 && len2 > 10) {
            host = host.substring(0, 10);
        }
        this.domain = host + "." + this.dataMaster.getRandomValue("domains");
    }

    @Override
    public void generateEmail() {
        if (this.email != null) {
            return;
        }
        this.email = this.dataMaster.getRandomValue("companyEmails");
    }

    @Override
    public void generateVatIdentificationNumber() {
        if (this.vatIdentificationNumber != null) {
            return;
        }
        this.vatIdentificationNumber = this.vatIdentificationNumberProvider.get();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public void setVatIdentificationNumber(String vatIdentificationNumber) {
        this.vatIdentificationNumber = vatIdentificationNumber;
    }
}

