/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.payment;

import com.google.inject.Provider;
import io.codearte.jfairy.data.DataMaster;
import io.codearte.jfairy.producer.DateProducer;
import io.codearte.jfairy.producer.payment.CreditCard;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class CreditCardProvider
implements Provider<CreditCard> {
    private static final Period DEFAULT_VALIDITY = Period.months((int)36);
    private static final String DATA_KEY = "cardVendors";
    private final DataMaster dataMaster;
    private final DateProducer dateProducer;

    @Inject
    public CreditCardProvider(DataMaster dataMaster, DateProducer dateProducer) {
        this.dataMaster = dataMaster;
        this.dateProducer = dateProducer;
    }

    public CreditCard get() {
        String cardVendor = this.dataMaster.getRandomValue(DATA_KEY);
        DateTime expiryDate = this.dateProducer.randomDateBetweenNowAndFuturePeriod(DEFAULT_VALIDITY);
        return new CreditCard(cardVendor, expiryDate);
    }
}

