/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.person.locale.pl;

import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.DateProducer;
import io.codearte.jfairy.producer.person.NationalIdentificationNumber;
import io.codearte.jfairy.producer.person.NationalIdentificationNumberProperties;
import io.codearte.jfairy.producer.person.NationalIdentificationNumberProvider;
import io.codearte.jfairy.producer.person.Person;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class PlNationalIdentificationNumberProvider
implements NationalIdentificationNumberProvider {
    private static final int NATIONAL_IDENTIFICATION_NUMBER_LENGTH = 11;
    private static final int VALIDITY_IN_YEARS = 10;
    private static final int[] PERIOD_WEIGHTS = new int[]{80, 0, 20, 40, 60};
    private static final int PERIOD_FACTOR = 100;
    private static final int BEGIN_YEAR = 1800;
    private static final int[] WEIGHTS = new int[]{1, 3, 7, 9, 1, 3, 7, 9, 1, 3};
    private static final int MAX_SERIAL_NUMBER = 999;
    private static final int TEN = 10;
    private static final int[] SEX_FIELDS = new int[]{0, 2, 4, 6, 8};
    private final BaseProducer baseProducer;
    private final DateProducer dateProducer;
    private DateTime issueDate;
    private Person.Sex sex;

    @Inject
    public PlNationalIdentificationNumberProvider(DateProducer dateProducer, BaseProducer baseProducer, NationalIdentificationNumberProperties.Property ... properties) {
        this.dateProducer = dateProducer;
        this.baseProducer = baseProducer;
        this.with(properties);
    }

    public void with(NationalIdentificationNumberProperties.Property[] properties) {
        for (NationalIdentificationNumberProperties.Property property : properties) {
            property.apply(this);
        }
    }

    @Override
    public NationalIdentificationNumber get() {
        if (this.issueDate == null) {
            this.issueDate = this.dateProducer.randomDateInThePast(10);
        }
        if (this.sex == null) {
            this.sex = this.baseProducer.trueOrFalse() ? Person.Sex.MALE : Person.Sex.FEMALE;
        }
        return new NationalIdentificationNumber(this.generate());
    }

    private String generate() {
        int year = this.issueDate.getYearOfCentury();
        int month = this.calculateMonth(this.issueDate.getMonthOfYear(), this.issueDate.getYear());
        int day = this.issueDate.getDayOfMonth();
        int serialNumber = this.baseProducer.randomInt(999);
        int sexCode = this.calculateSexCode(this.sex);
        String nationalIdentificationNumber = String.format("%02d%02d%02d%03d%d", year, month, day, serialNumber, sexCode);
        return nationalIdentificationNumber + PlNationalIdentificationNumberProvider.calculateChecksum(nationalIdentificationNumber);
    }

    @Override
    public void setIssueDate(DateTime issueDate) {
        this.issueDate = issueDate;
    }

    @Override
    public void setSex(Person.Sex sex) {
        this.sex = sex;
    }

    public static boolean isValid(String nationalIdentificationNumber) {
        int size = nationalIdentificationNumber.length();
        if (size != 11) {
            return false;
        }
        int checksum = Integer.valueOf(nationalIdentificationNumber.substring(size - 1));
        int checkDigit = PlNationalIdentificationNumberProvider.calculateChecksum(nationalIdentificationNumber);
        return checkDigit == checksum;
    }

    private int calculateMonth(int month, int year) {
        return month + PERIOD_WEIGHTS[(year - 1800) / 100];
    }

    private int calculateSexCode(Person.Sex sex) {
        return SEX_FIELDS[this.baseProducer.randomInt(SEX_FIELDS.length - 1)] + (sex == Person.Sex.MALE ? 1 : 0);
    }

    private static int calculateChecksum(String nationalIdentificationNumber) {
        int sum = 0;
        int i = 0;
        for (int weight : WEIGHTS) {
            int digit = Character.digit(nationalIdentificationNumber.charAt(i++), 10);
            sum += digit * weight;
        }
        int checksum = sum % 10;
        if (0 == checksum) {
            return 0;
        }
        return 10 - checksum;
    }
}

