/*
 * Decompiled with CFR 0.152.
 */
package org.iban4j;

import org.iban4j.BicFormatException;
import org.iban4j.CountryCode;
import org.iban4j.UnsupportedCountryException;

public class BicUtil {
    private static final int BIC8_LENGTH = 8;
    private static final int BIC11_LENGTH = 11;
    private static final int BANK_CODE_INDEX = 0;
    private static final int BANK_CODE_LENGTH = 4;
    private static final int COUNTRY_CODE_INDEX = 4;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int LOCATION_CODE_INDEX = 6;
    private static final int LOCATION_CODE_LENGTH = 2;
    private static final int BRANCH_CODE_INDEX = 8;
    private static final int BRANCH_CODE_LENGTH = 3;

    public static void validate(String bic) throws BicFormatException, UnsupportedCountryException {
        try {
            BicUtil.validateEmpty(bic);
            BicUtil.validateLength(bic);
            BicUtil.validateCase(bic);
            BicUtil.validateBankCode(bic);
            BicUtil.validateCountryCode(bic);
            BicUtil.validateLocationCode(bic);
            if (BicUtil.hasBranchCode(bic)) {
                BicUtil.validateBranchCode(bic);
            }
        }
        catch (UnsupportedCountryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new BicFormatException(BicFormatException.BicFormatViolation.UNKNOWN, e.getMessage());
        }
    }

    private static void validateEmpty(String bic) {
        if (bic == null) {
            throw new BicFormatException(BicFormatException.BicFormatViolation.BIC_NOT_NULL, "Null can't be a valid Bic.");
        }
        if (bic.length() == 0) {
            throw new BicFormatException(BicFormatException.BicFormatViolation.BIC_NOT_EMPTY, "Empty string can't be a valid Bic.");
        }
    }

    private static void validateLength(String bic) {
        if (bic.length() != 8 && bic.length() != 11) {
            throw new BicFormatException(BicFormatException.BicFormatViolation.BIC_LENGTH_8_OR_11, String.format("Bic length must be %d or %d", 8, 11));
        }
    }

    private static void validateCase(String bic) {
        if (!bic.equals(bic.toUpperCase())) {
            throw new BicFormatException(BicFormatException.BicFormatViolation.BIC_ONLY_UPPER_CASE_LETTERS, "Bic must contain only upper case letters.");
        }
    }

    private static void validateBankCode(String bic) {
        String bankCode = BicUtil.getBankCode(bic);
        for (char ch : bankCode.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            throw new BicFormatException(BicFormatException.BicFormatViolation.BANK_CODE_ONLY_LETTERS, Character.valueOf(ch), "Bank code must contain only letters.");
        }
    }

    private static void validateCountryCode(String bic) {
        String countryCode = BicUtil.getCountryCode(bic);
        if (!(countryCode.trim().length() >= 2 && countryCode.equals(countryCode.toUpperCase()) && Character.isLetter(countryCode.charAt(0)) && Character.isLetter(countryCode.charAt(1)))) {
            throw new BicFormatException(BicFormatException.BicFormatViolation.COUNTRY_CODE_ONLY_UPPER_CASE_LETTERS, countryCode, "Bic country code must contain upper case letters");
        }
        if (CountryCode.getByCode(countryCode) == null) {
            throw new UnsupportedCountryException(countryCode, "Country code is not supported.");
        }
    }

    private static void validateLocationCode(String bic) {
        String locationCode = BicUtil.getLocationCode(bic);
        for (char ch : locationCode.toCharArray()) {
            if (Character.isLetterOrDigit(ch)) continue;
            throw new BicFormatException(BicFormatException.BicFormatViolation.LOCATION_CODE_ONLY_LETTERS_OR_DIGITS, Character.valueOf(ch), "Location code must contain only letters or digits.");
        }
    }

    private static void validateBranchCode(String bic) {
        String branchCode = BicUtil.getBranchCode(bic);
        for (char ch : branchCode.toCharArray()) {
            if (Character.isLetterOrDigit(ch)) continue;
            throw new BicFormatException(BicFormatException.BicFormatViolation.BRANCH_CODE_ONLY_LETTERS_OR_DIGITS, Character.valueOf(ch), "Branch code must contain only letters or digits.");
        }
    }

    static String getBankCode(String bic) {
        return bic.substring(0, 4);
    }

    static String getCountryCode(String bic) {
        return bic.substring(4, 6);
    }

    static String getLocationCode(String bic) {
        return bic.substring(6, 8);
    }

    static String getBranchCode(String bic) {
        return bic.substring(8, 11);
    }

    static boolean hasBranchCode(String bic) {
        return bic.length() == 11;
    }
}

