/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ExpireDelegationTokenResponseData
implements ApiMessage {
    short errorCode;
    long expiryTimestampMs;
    int throttleTimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public ExpireDelegationTokenResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ExpireDelegationTokenResponseData() {
        this.errorCode = 0;
        this.expiryTimestampMs = 0L;
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 40;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        this.expiryTimestampMs = _readable.readLong();
        this.throttleTimeMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        _writable.writeLong(this.expiryTimestampMs);
        _writable.writeInt(this.throttleTimeMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(8);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpireDelegationTokenResponseData)) {
            return false;
        }
        ExpireDelegationTokenResponseData other = (ExpireDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.expiryTimestampMs != other.expiryTimestampMs) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + ((int)(this.expiryTimestampMs >> 32) ^ (int)this.expiryTimestampMs);
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    @Override
    public ExpireDelegationTokenResponseData duplicate() {
        ExpireDelegationTokenResponseData _duplicate = new ExpireDelegationTokenResponseData();
        _duplicate.errorCode = this.errorCode;
        _duplicate.expiryTimestampMs = this.expiryTimestampMs;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        return _duplicate;
    }

    public String toString() {
        return "ExpireDelegationTokenResponseData(errorCode=" + this.errorCode + ", expiryTimestampMs=" + this.expiryTimestampMs + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public long expiryTimestampMs() {
        return this.expiryTimestampMs;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ExpireDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ExpireDelegationTokenResponseData setExpiryTimestampMs(long v) {
        this.expiryTimestampMs = v;
        return this;
    }

    public ExpireDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("expiry_timestamp_ms", Type.INT64, "The timestamp in milliseconds at which this token expires."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("expiry_timestamp_ms", Type.INT64, "The timestamp in milliseconds at which this token expires."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

