/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.KinesisClientLibIOException;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseCleanupValidator;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamsLeaseCleanupValidator
implements LeaseCleanupValidator {
    private static final Log LOG = LogFactory.getLog(StreamsLeaseCleanupValidator.class);

    public boolean isCandidateForCleanup(KinesisClientLease lease, Set<String> currentKinesisShardIds) throws KinesisClientLibIOException {
        boolean isCandidateForCleanup = true;
        if (currentKinesisShardIds.contains(lease.getLeaseKey())) {
            isCandidateForCleanup = false;
        } else {
            LOG.info((Object)("Found lease for non-existent shard: " + lease.getLeaseKey() + ". Checking its parent shards"));
            Set parentShardIds = lease.getParentShardIds();
            for (String parentShardId : parentShardIds) {
                if (!currentKinesisShardIds.contains(parentShardId)) continue;
                String message = "Parent shard " + parentShardId + " exists but not the child shard " + lease.getLeaseKey();
                LOG.info((Object)message);
                throw new KinesisClientLibIOException(message);
            }
        }
        return isCandidateForCleanup;
    }
}

