/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.KinesisClientLibIOException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.Checkpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.GenericLeaseSelector;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.LeaseCoordinator;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseRenewer;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseTaker;
import com.amazonaws.services.kinesis.leases.interfaces.LeaseSelector;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KinesisClientLibLeaseCoordinator
extends LeaseCoordinator<KinesisClientLease>
implements ICheckpoint {
    private static final Log LOG = LogFactory.getLog(KinesisClientLibLeaseCoordinator.class);
    private static final long DEFAULT_INITIAL_LEASE_TABLE_READ_CAPACITY = 10L;
    private static final long DEFAULT_INITIAL_LEASE_TABLE_WRITE_CAPACITY = 10L;
    private static final LeaseSelector<KinesisClientLease> DEFAULT_LEASE_SELECTOR = new GenericLeaseSelector<KinesisClientLease>();
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private long initialLeaseTableReadCapacity = 10L;
    private long initialLeaseTableWriteCapacity = 10L;

    public KinesisClientLibLeaseCoordinator(ILeaseManager<KinesisClientLease> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, LeaseSelector<KinesisClientLease> leaseSelector) {
        super(leaseManager, leaseSelector, workerIdentifier, leaseDurationMillis, epsilonMillis);
        this.leaseManager = leaseManager;
    }

    public KinesisClientLibLeaseCoordinator(ILeaseManager<KinesisClientLease> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis) {
        this(leaseManager, workerIdentifier, leaseDurationMillis, epsilonMillis, DEFAULT_LEASE_SELECTOR);
    }

    public KinesisClientLibLeaseCoordinator(ILeaseManager<KinesisClientLease> leaseManager, LeaseSelector<KinesisClientLease> leaseSelector, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, IMetricsFactory metricsFactory) {
        super(leaseManager, leaseSelector, workerIdentifier, leaseDurationMillis, epsilonMillis, metricsFactory);
        this.leaseManager = leaseManager;
    }

    public KinesisClientLibLeaseCoordinator(ILeaseManager<KinesisClientLease> leaseManager, LeaseSelector<KinesisClientLease> leaseSelector, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewerThreadCount, IMetricsFactory metricsFactory) {
        super(leaseManager, leaseSelector, workerIdentifier, leaseDurationMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewerThreadCount, metricsFactory);
        this.leaseManager = leaseManager;
    }

    public KinesisClientLibLeaseCoordinator(ILeaseManager<KinesisClientLease> leaseManager, ILeaseTaker<KinesisClientLease> leaseTaker, ILeaseRenewer<KinesisClientLease> leaseRenewer, long leaseDurationMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, IMetricsFactory metricsFactory) {
        super(leaseTaker, leaseRenewer, leaseDurationMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, metricsFactory);
        this.leaseManager = leaseManager;
    }

    public KinesisClientLibLeaseCoordinator withInitialLeaseTableReadCapacity(long readCapacity) {
        if (readCapacity <= 0L) {
            throw new IllegalArgumentException("readCapacity should be >= 1");
        }
        this.initialLeaseTableReadCapacity = readCapacity;
        return this;
    }

    public KinesisClientLibLeaseCoordinator withInitialLeaseTableWriteCapacity(long writeCapacity) {
        if (writeCapacity <= 0L) {
            throw new IllegalArgumentException("writeCapacity should be >= 1");
        }
        this.initialLeaseTableWriteCapacity = writeCapacity;
        return this;
    }

    boolean setCheckpoint(String shardId, ExtendedSequenceNumber checkpoint, UUID concurrencyToken) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        KinesisClientLease lease = (KinesisClientLease)this.getCurrentlyHeldLease(shardId);
        if (lease == null) {
            LOG.info((Object)String.format("Worker %s could not update checkpoint for shard %s because it does not hold the lease", this.getWorkerIdentifier(), shardId));
            return false;
        }
        lease.setCheckpoint(checkpoint);
        lease.setPendingCheckpoint(null);
        lease.setOwnerSwitchesSinceCheckpoint(0L);
        return this.updateLease(lease, concurrencyToken);
    }

    @Override
    public void setCheckpoint(String shardId, ExtendedSequenceNumber checkpointValue, String concurrencyToken) throws KinesisClientLibException {
        try {
            boolean wasSuccessful = this.setCheckpoint(shardId, checkpointValue, UUID.fromString(concurrencyToken));
            if (!wasSuccessful) {
                throw new ShutdownException("Can't update checkpoint - instance doesn't hold the lease for this shard");
            }
        }
        catch (ProvisionedThroughputException e) {
            throw new ThrottlingException("Got throttled while updating checkpoint.", e);
        }
        catch (InvalidStateException e) {
            String message = "Unable to save checkpoint for shardId " + shardId;
            LOG.error((Object)message, (Throwable)e);
            throw new com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException(message, e);
        }
        catch (DependencyException e) {
            throw new KinesisClientLibDependencyException("Unable to save checkpoint for shardId " + shardId, e);
        }
    }

    @Override
    public ExtendedSequenceNumber getCheckpoint(String shardId) throws KinesisClientLibException {
        try {
            return this.leaseManager.getLease(shardId).getCheckpoint();
        }
        catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
            String message = "Unable to fetch checkpoint for shardId " + shardId;
            LOG.error((Object)message, (Throwable)e);
            throw new KinesisClientLibIOException(message, e);
        }
    }

    boolean prepareCheckpoint(String shardId, ExtendedSequenceNumber pendingCheckpoint, UUID concurrencyToken) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        KinesisClientLease lease = (KinesisClientLease)this.getCurrentlyHeldLease(shardId);
        if (lease == null) {
            LOG.info((Object)String.format("Worker %s could not prepare checkpoint for shard %s because it does not hold the lease", this.getWorkerIdentifier(), shardId));
            return false;
        }
        lease.setPendingCheckpoint(Objects.requireNonNull(pendingCheckpoint, "pendingCheckpoint should not be null"));
        return this.updateLease(lease, concurrencyToken);
    }

    @Override
    public void prepareCheckpoint(String shardId, ExtendedSequenceNumber pendingCheckpointValue, String concurrencyToken) throws KinesisClientLibException {
        try {
            boolean wasSuccessful = this.prepareCheckpoint(shardId, pendingCheckpointValue, UUID.fromString(concurrencyToken));
            if (!wasSuccessful) {
                throw new ShutdownException("Can't prepare checkpoint - instance doesn't hold the lease for this shard");
            }
        }
        catch (ProvisionedThroughputException e) {
            throw new ThrottlingException("Got throttled while preparing checkpoint.", e);
        }
        catch (InvalidStateException e) {
            String message = "Unable to prepare checkpoint for shardId " + shardId;
            LOG.error((Object)message, (Throwable)e);
            throw new com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException(message, e);
        }
        catch (DependencyException e) {
            throw new KinesisClientLibDependencyException("Unable to prepare checkpoint for shardId " + shardId, e);
        }
    }

    @Override
    public Checkpoint getCheckpointObject(String shardId) throws KinesisClientLibException {
        String errorMessage = "Unable to fetch checkpoint for shardId " + shardId;
        try {
            KinesisClientLease lease = this.leaseManager.getLease(shardId);
            if (lease == null) {
                throw new KinesisClientLibIOException(errorMessage);
            }
            return new Checkpoint(lease.getCheckpoint(), lease.getPendingCheckpoint());
        }
        catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new KinesisClientLibIOException(errorMessage, e);
        }
    }

    public List<ShardInfo> getCurrentAssignments() {
        Collection<KinesisClientLease> leases = this.getAssignments();
        return KinesisClientLibLeaseCoordinator.convertLeasesToAssignments(leases);
    }

    public static List<ShardInfo> convertLeasesToAssignments(Collection<KinesisClientLease> leases) {
        if (leases == null || leases.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ShardInfo> assignments = new ArrayList<ShardInfo>(leases.size());
        for (KinesisClientLease lease : leases) {
            assignments.add(KinesisClientLibLeaseCoordinator.convertLeaseToAssignment(lease));
        }
        return assignments;
    }

    public static ShardInfo convertLeaseToAssignment(KinesisClientLease lease) {
        Set<String> parentShardIds = lease.getParentShardIds();
        return new ShardInfo(lease.getLeaseKey(), lease.getConcurrencyToken().toString(), parentShardIds, lease.getCheckpoint());
    }

    void initialize() throws ProvisionedThroughputException, DependencyException, IllegalStateException {
        boolean newTableCreated = this.leaseManager.createLeaseTableIfNotExists(this.initialLeaseTableReadCapacity, this.initialLeaseTableWriteCapacity);
        if (newTableCreated) {
            LOG.info((Object)String.format("Created new lease table for coordinator with initial read capacity of %d and write capacity of %d.", this.initialLeaseTableReadCapacity, this.initialLeaseTableWriteCapacity));
        }
        long secondsBetweenPolls = 10L;
        long timeoutSeconds = 600L;
        boolean isTableActive = this.leaseManager.waitUntilLeaseTableExists(10L, 600L);
        if (!isTableActive) {
            throw new DependencyException(new IllegalStateException("Creating table timeout"));
        }
    }

    void runLeaseTaker() throws DependencyException, InvalidStateException {
        super.runTaker();
    }

    void runLeaseRenewer() throws DependencyException, InvalidStateException {
        super.runRenewer();
    }

    ILeaseManager<KinesisClientLease> getLeaseManager() {
        return this.leaseManager;
    }
}

