/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.flume.channel.jdbc.ConfigurationConstants;
import org.apache.flume.channel.jdbc.JdbcChannelException;

public class PersistableEvent
implements Event {
    private long eventId;
    private final String channel;
    private byte[] basePayload;
    private byte[] spillPayload;
    private List<HeaderEntry> headers;

    public PersistableEvent(String channel, Event event) {
        this.channel = channel;
        byte[] givenPayload = event.getBody();
        if (givenPayload.length < ConfigurationConstants.PAYLOAD_LENGTH_THRESHOLD) {
            this.basePayload = Arrays.copyOf(givenPayload, givenPayload.length);
            this.spillPayload = null;
        } else {
            this.basePayload = Arrays.copyOfRange(givenPayload, 0, ConfigurationConstants.PAYLOAD_LENGTH_THRESHOLD);
            this.spillPayload = Arrays.copyOfRange(givenPayload, ConfigurationConstants.PAYLOAD_LENGTH_THRESHOLD, givenPayload.length);
        }
        Map headerMap = event.getHeaders();
        if (headerMap != null && headerMap.size() > 0) {
            this.headers = new ArrayList<HeaderEntry>();
            for (Map.Entry entry : headerMap.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.headers.add(new HeaderEntry(name, value));
            }
        }
    }

    private PersistableEvent(long eventId, String channel, byte[] basePayload, byte[] spillPayload, List<HeaderEntry> headers) {
        this.eventId = eventId;
        this.channel = channel;
        this.basePayload = basePayload;
        this.spillPayload = spillPayload;
        this.headers = headers;
    }

    public String getChannelName() {
        return this.channel;
    }

    public byte[] getBasePayload() {
        return this.basePayload;
    }

    public byte[] getSpillPayload() {
        return this.spillPayload;
    }

    protected void setEventId(long eventId) {
        this.eventId = eventId;
    }

    protected long getEventId() {
        return this.eventId;
    }

    public List<HeaderEntry> getHeaderEntries() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        throw new UnsupportedOperationException("Cannot update headers of persistable event");
    }

    public byte[] getBody() {
        byte[] result = null;
        if (this.spillPayload == null) {
            result = Arrays.copyOf(this.basePayload, this.basePayload.length);
        } else {
            result = new byte[this.basePayload.length + this.spillPayload.length];
            System.arraycopy(this.basePayload, 0, result, 0, this.basePayload.length);
            System.arraycopy(this.spillPayload, 0, result, this.basePayload.length, this.spillPayload.length);
        }
        return result;
    }

    public void setBody(byte[] body) {
        throw new UnsupportedOperationException("Cannot update payload of persistable event");
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headerMap = null;
        if (this.headers != null) {
            headerMap = new HashMap<String, String>();
            for (HeaderEntry entry : this.headers) {
                headerMap.put(entry.getNameString(), entry.getValueString());
            }
        }
        return headerMap;
    }

    private static class HeaderPart {
        private final String hBaseName;
        private final String hBaseValue;
        private String hSpillName;
        private String hSpillValue;

        HeaderPart(String baseName, String baseValue) {
            this.hBaseName = baseName;
            this.hBaseValue = baseValue;
        }

        String getBaseName() {
            return this.hBaseName;
        }

        String getBaseValue() {
            return this.hBaseValue;
        }

        String getSpillName() {
            return this.hSpillName;
        }

        String getSpillValue() {
            return this.hSpillValue;
        }

        void setSpillName(String spillName) {
            this.hSpillName = spillName;
        }

        void setSpillValue(String spillValue) {
            this.hSpillValue = spillValue;
        }

        HeaderEntry getEntry(long headerId) {
            return new HeaderEntry(headerId, this.hBaseName, this.hSpillName, this.hBaseValue, this.hSpillValue);
        }
    }

    public static class Builder {
        private long bEventId;
        private String bChannelName;
        private byte[] bBasePayload;
        private byte[] bSpillPayload;
        private Map<Long, HeaderPart> bHeaderParts;

        public Builder(String channelName, long eventId) {
            this.bChannelName = channelName;
            this.bEventId = eventId;
        }

        public Builder setEventId(long eventId) {
            this.bEventId = eventId;
            return this;
        }

        public Builder setChannel(String channel) {
            this.bChannelName = channel;
            return this;
        }

        public Builder setBasePayload(byte[] basePayload) {
            this.bBasePayload = basePayload;
            return this;
        }

        public Builder setSpillPayload(byte[] spillPayload) {
            this.bSpillPayload = spillPayload;
            return this;
        }

        public Builder setHeader(long headerId, String baseName, String baseValue) {
            if (this.bHeaderParts == null) {
                this.bHeaderParts = new HashMap<Long, HeaderPart>();
            }
            HeaderPart hp = new HeaderPart(baseName, baseValue);
            if (this.bHeaderParts.put(headerId, hp) != null) {
                throw new JdbcChannelException("Duplicate header found: headerId: " + headerId + ", baseName: " + baseName + ", baseValue: " + baseValue);
            }
            return this;
        }

        public Builder setHeaderNameSpill(long headerId, String nameSpill) {
            HeaderPart hp = this.bHeaderParts.get(headerId);
            if (hp == null) {
                throw new JdbcChannelException("Header not found for spill: " + headerId);
            }
            hp.setSpillName(nameSpill);
            return this;
        }

        public Builder setHeaderValueSpill(long headerId, String valueSpill) {
            HeaderPart hp = this.bHeaderParts.get(headerId);
            if (hp == null) {
                throw new JdbcChannelException("Header not found for spill: " + headerId);
            }
            hp.setSpillValue(valueSpill);
            return this;
        }

        public PersistableEvent build() {
            ArrayList<HeaderEntry> bHeaders = new ArrayList<HeaderEntry>();
            if (this.bHeaderParts != null) {
                for (long headerId : this.bHeaderParts.keySet()) {
                    HeaderPart part = this.bHeaderParts.get(headerId);
                    bHeaders.add(part.getEntry(headerId));
                }
            }
            PersistableEvent pe = new PersistableEvent(this.bEventId, this.bChannelName, this.bBasePayload, this.bSpillPayload, bHeaders);
            this.bEventId = 0L;
            this.bChannelName = null;
            this.bBasePayload = null;
            this.bSpillPayload = null;
            this.bHeaderParts = null;
            return pe;
        }
    }

    protected static class SpillableString {
        private String base;
        private String spill;

        public SpillableString(String string, int threshold) {
            if (string.getBytes().length < threshold) {
                this.base = string;
            } else {
                int length;
                int currentIndex;
                int lastIndex = currentIndex = threshold / 3;
                while ((length = string.substring(0, currentIndex).getBytes().length) < threshold) {
                    lastIndex = currentIndex++;
                }
                this.base = string.substring(0, lastIndex);
                this.spill = string.substring(lastIndex);
            }
        }

        private SpillableString(String base, String spill) {
            this.base = base;
            this.spill = spill;
        }

        public String getBase() {
            return this.base;
        }

        public String getSpill() {
            return this.spill;
        }

        public String getString() {
            if (this.spill == null) {
                return this.base;
            }
            return this.base + this.spill;
        }

        public boolean hasSpill() {
            return this.spill != null;
        }
    }

    protected static class HeaderEntry {
        private long headerId = -1L;
        private SpillableString name;
        private SpillableString value;

        public HeaderEntry(String name, String value) {
            this.name = new SpillableString(name, ConfigurationConstants.HEADER_NAME_LENGTH_THRESHOLD);
            this.value = new SpillableString(value, ConfigurationConstants.HEADER_VALUE_LENGTH_THRESHOLD);
        }

        private HeaderEntry(long headerId, String baseName, String spillName, String baseValue, String spillValue) {
            this.headerId = headerId;
            this.name = new SpillableString(baseName, spillName);
            this.value = new SpillableString(baseValue, spillValue);
        }

        public String getNameString() {
            return this.name.getString();
        }

        public SpillableString getName() {
            return this.name;
        }

        public String getValueString() {
            return this.value.getString();
        }

        public SpillableString getValue() {
            return this.value;
        }

        protected void setId(long headerId) {
            this.headerId = headerId;
        }

        public long getId() {
            return this.headerId;
        }
    }
}

