/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;

public class ReferencedColumnsDescriptorImpl
implements ReferencedColumns,
Formatable {
    private int[] referencedColumns;
    private int[] referencedColumnsInTriggerAction;

    public ReferencedColumnsDescriptorImpl(int[] nArray) {
        this.referencedColumns = ArrayUtil.copy(nArray);
    }

    public ReferencedColumnsDescriptorImpl(int[] nArray, int[] nArray2) {
        this.referencedColumns = ArrayUtil.copy(nArray);
        this.referencedColumnsInTriggerAction = ArrayUtil.copy(nArray2);
    }

    public ReferencedColumnsDescriptorImpl() {
    }

    @Override
    public int[] getReferencedColumnPositions() {
        return ArrayUtil.copy(this.referencedColumns);
    }

    @Override
    public int[] getTriggerActionReferencedColumnPositions() {
        return ArrayUtil.copy(this.referencedColumnsInTriggerAction);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n;
        int n2;
        int n3 = objectInput.readInt();
        if (n3 < 0) {
            n2 = objectInput.readInt();
            if (n2 < 0) {
                n2 = 0;
            } else {
                this.referencedColumns = new int[n2];
            }
        } else {
            n2 = n3;
            this.referencedColumns = new int[n2];
        }
        for (n = 0; n < n2; ++n) {
            this.referencedColumns[n] = objectInput.readInt();
        }
        if (n3 < 0) {
            n = objectInput.readInt();
            this.referencedColumnsInTriggerAction = new int[n];
            for (int i = 0; i < n; ++i) {
                this.referencedColumnsInTriggerAction[i] = objectInput.readInt();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = n = this.referencedColumnsInTriggerAction == null ? this.referencedColumns.length : -1;
        if (n < 0) {
            objectOutput.writeInt(n);
            if (this.referencedColumns != null) {
                this.writeReferencedColumns(objectOutput);
            } else {
                objectOutput.writeInt(n);
            }
            objectOutput.writeInt(this.referencedColumnsInTriggerAction.length);
            for (int i = 0; i < this.referencedColumnsInTriggerAction.length; ++i) {
                objectOutput.writeInt(this.referencedColumnsInTriggerAction[i]);
            }
        } else {
            this.writeReferencedColumns(objectOutput);
        }
    }

    private void writeReferencedColumns(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.referencedColumns.length);
        for (int i = 0; i < this.referencedColumns.length; ++i) {
            objectOutput.writeInt(this.referencedColumns[i]);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 205;
    }

    public String toString() {
        if (this.referencedColumns == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('(');
        for (int i = 0; i < this.referencedColumns.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(String.valueOf(this.referencedColumns[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

