/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.channel.AbstractChannelSelector;

public class LoadBalancingChannelSelector
extends AbstractChannelSelector {
    private final List<Channel> emptyList = Collections.emptyList();
    private ChannelPicker picker;

    @Override
    public List<Channel> getRequiredChannels(Event event) {
        Channel ch = this.picker.getChannel();
        Preconditions.checkNotNull((Object)ch, (Object)"Channel picker returned null");
        return Lists.newArrayList((Object[])new Channel[]{ch});
    }

    @Override
    public List<Channel> getOptionalChannels(Event event) {
        return this.emptyList;
    }

    @Override
    public void configure(Context context) {
        Policy policy;
        List<Channel> channels = this.getAllChannels();
        String strPolicy = context.getString("policy", Policy.ROUND_ROBIN.toString());
        try {
            policy = Policy.valueOf(strPolicy.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid policy: " + strPolicy, ex);
        }
        try {
            this.picker = policy.getPolicyClass().newInstance();
            this.picker.setChannels(channels);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException("Cannot instantiate policy class from policy enum " + (Object)((Object)policy), ex);
        }
    }

    private static class RandomPolicy
    implements ChannelPicker {
        private List<Channel> channels;
        private final Random random = new Random(System.currentTimeMillis());

        @Override
        public void setChannels(List<Channel> channels) {
            this.channels = channels;
        }

        @Override
        public Channel getChannel() {
            int size = this.channels.size();
            int pick = this.random.nextInt(size);
            return this.channels.get(pick);
        }
    }

    private static class RoundRobinPolicy
    implements ChannelPicker {
        private final AtomicInteger next = new AtomicInteger(0);
        private List<Channel> channels;

        @Override
        public void setChannels(List<Channel> channels) {
            this.channels = channels;
        }

        @Override
        public Channel getChannel() {
            return this.channels.get(this.next.getAndAccumulate(this.channels.size(), (x, y) -> ++x < y ? x : 0));
        }
    }

    private static interface ChannelPicker {
        public Channel getChannel();

        public void setChannels(List<Channel> var1);
    }

    private static enum Policy {
        ROUND_ROBIN(RoundRobinPolicy.class),
        RANDOM(RandomPolicy.class);

        private final Class<? extends ChannelPicker> clazz;

        private Policy(Class<? extends ChannelPicker> clazz) {
            this.clazz = clazz;
        }

        public Class<? extends ChannelPicker> getPolicyClass() {
            return this.clazz;
        }
    }
}

