/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.formatter.output;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.formatter.output.PathManager;
import org.apache.flume.formatter.output.PathManagerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(PathManagerFactory.class);

    public static PathManager getInstance(String managerType, Context context) {
        PathManager.Builder builder;
        PathManagerType type;
        Preconditions.checkNotNull((Object)managerType, (Object)"path manager type must not be null");
        try {
            type = PathManagerType.valueOf(managerType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Not in enum, loading builder class: {}", (Object)managerType);
            type = PathManagerType.OTHER;
        }
        Class<PathManager.Builder> builderClass = type.getBuilderClass();
        if (builderClass == null) {
            try {
                Class<?> c = Class.forName(managerType);
                if (c == null || !PathManager.Builder.class.isAssignableFrom(c)) {
                    String errMessage = "Unable to instantiate Builder from " + managerType + ": does not appear to implement " + PathManager.Builder.class.getName();
                    throw new FlumeException(errMessage);
                }
                builderClass = c;
            }
            catch (ClassNotFoundException ex) {
                logger.error("Class not found: " + managerType, (Throwable)ex);
                throw new FlumeException((Throwable)ex);
            }
        }
        try {
            builder = builderClass.newInstance();
        }
        catch (InstantiationException ex) {
            String errMessage = "Cannot instantiate builder: " + managerType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            String errMessage = "Cannot instantiate builder: " + managerType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, (Throwable)ex);
        }
        return builder.build(context);
    }
}

