/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetcatUdpSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private int port;
    private String host = null;
    private Channel nettyChannel;
    private String remoteHostHeader = "REMOTE_ADDRESS";
    private EventLoopGroup group;
    private static final Logger logger = LoggerFactory.getLogger(NetcatUdpSource.class);
    private CounterGroup counterGroup = new CounterGroup();
    private static final String REMOTE_ADDRESS_HEADER = "remoteAddress";
    private static final String CONFIG_PORT = "port";
    private static final String CONFIG_HOST = "bind";

    @Override
    public void start() {
        this.group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new NetcatHandler());
            this.nettyChannel = this.host == null ? b.bind(this.port).sync().channel() : b.bind(this.host, this.port).sync().channel();
        }
        catch (InterruptedException ex) {
            logger.warn("netty server startup was interrupted", (Throwable)ex);
        }
        super.start();
    }

    @Override
    public void stop() {
        logger.info("Netcat UDP Source stopping...");
        logger.info("Metrics:{}", (Object)this.counterGroup);
        this.group.shutdownGracefully();
        super.stop();
    }

    @Override
    public void configure(Context context) {
        Configurables.ensureRequiredNonNull(context, CONFIG_PORT);
        this.port = context.getInteger(CONFIG_PORT);
        this.host = context.getString(CONFIG_HOST);
        this.remoteHostHeader = context.getString(REMOTE_ADDRESS_HEADER);
    }

    @VisibleForTesting
    public int getSourcePort() {
        SocketAddress localAddress = this.nettyChannel.localAddress();
        if (localAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)localAddress;
            return addr.getPort();
        }
        return 0;
    }

    public class NetcatHandler
    extends SimpleChannelInboundHandler<DatagramPacket> {
        private Event extractEvent(ByteBuf in, SocketAddress remoteAddress) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(NetcatUdpSource.this.remoteHostHeader, remoteAddress.toString());
            byte b = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Event e = null;
            boolean doneReading = false;
            while (!doneReading && in.isReadable()) {
                b = in.readByte();
                if (b == 10) {
                    doneReading = true;
                    continue;
                }
                baos.write(b);
            }
            e = EventBuilder.withBody((byte[])baos.toByteArray(), headers);
            return e;
        }

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
            try {
                Event e = this.extractEvent((ByteBuf)packet.content(), packet.sender());
                if (e == null) {
                    return;
                }
                NetcatUdpSource.this.getChannelProcessor().processEvent(e);
                NetcatUdpSource.this.counterGroup.incrementAndGet("events.success");
            }
            catch (ChannelException ex) {
                NetcatUdpSource.this.counterGroup.incrementAndGet("events.dropped");
                logger.error("Error writing to channel", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                NetcatUdpSource.this.counterGroup.incrementAndGet("events.dropped");
                logger.error("Error retrieving event from udp stream, event dropped", (Throwable)ex);
            }
        }
    }
}

