/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.UserLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class User {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_OAUTH_I_D = "oauthID";
    @SerializedName(value="oauthID")
    private String oauthID;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private UserLinks links = null;

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public User oauthID(String oauthID) {
        this.oauthID = oauthID;
        return this;
    }

    @ApiModelProperty(value="")
    public String getOauthID() {
        return this.oauthID;
    }

    public void setOauthID(String oauthID) {
        this.oauthID = oauthID;
    }

    public User name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="If inactive the user is inactive.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public User links(UserLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public UserLinks getLinks() {
        return this.links;
    }

    public void setLinks(UserLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User userResponse = (User)o;
        return Objects.equals(this.id, userResponse.id) && Objects.equals(this.oauthID, userResponse.oauthID) && Objects.equals(this.name, userResponse.name) && Objects.equals((Object)this.status, (Object)userResponse.status) && Objects.equals(this.links, userResponse.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.oauthID, this.name, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    oauthID: ").append(this.toIndentedString(this.oauthID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

