/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel;

import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.Channel;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.ChannelException;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.channel.ChannelFactory;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import com.clickhouse.client.internal.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.lang.reflect.Constructor;

public class ReflectiveChannelFactory<T extends Channel>
implements ChannelFactory<T> {
    private final Constructor<? extends T> constructor;

    public ReflectiveChannelFactory(Class<? extends T> clazz) {
        ObjectUtil.checkNotNull(clazz, "clazz");
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + StringUtil.simpleClassName(clazz) + " does not have a public non-arg constructor", e);
        }
    }

    @Override
    public T newChannel() {
        try {
            return (T)((Channel)this.constructor.newInstance(new Object[0]));
        }
        catch (Throwable t) {
            throw new ChannelException("Unable to create Channel from class " + this.constructor.getDeclaringClass(), t);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(ReflectiveChannelFactory.class) + '(' + StringUtil.simpleClassName(this.constructor.getDeclaringClass()) + ".class)";
    }
}

