/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.client.AsyncListDatabasesIterable;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class ListDatabasesPublisherImpl<TResult>
implements ListDatabasesPublisher<TResult> {
    private final AsyncListDatabasesIterable<TResult> wrapped;

    ListDatabasesPublisherImpl(AsyncListDatabasesIterable<TResult> wrapped) {
        this.wrapped = (AsyncListDatabasesIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public ListDatabasesPublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListDatabasesPublisher<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public ListDatabasesPublisher<TResult> nameOnly(Boolean nameOnly) {
        this.wrapped.nameOnly(nameOnly);
        return this;
    }

    @Override
    public ListDatabasesPublisher<TResult> authorizedDatabasesOnly(Boolean authorizedDatabasesOnly) {
        this.wrapped.authorizedDatabasesOnly(authorizedDatabasesOnly);
        return this;
    }

    @Override
    public ListDatabasesPublisher<TResult> batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public Publisher<TResult> first() {
        return Publishers.publish(arg_0 -> this.wrapped.first(arg_0));
    }

    public void subscribe(Subscriber<? super TResult> s) {
        Publishers.publish(this.wrapped).subscribe(s);
    }
}

