/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.shard;

import lombok.NonNull;

public class NamespaceNotFoundException
extends RuntimeException {
    private final String namespace;
    private final boolean retryable;

    public NamespaceNotFoundException(@NonNull String namespace) {
        super(String.format("namespace %s not found in shards assignments", namespace));
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        this.retryable = false;
        this.namespace = namespace;
    }

    public NamespaceNotFoundException(@NonNull String namespace, boolean retryable) {
        super(String.format("namespace %s not found in shards assignments", namespace));
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        this.retryable = retryable;
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isRetryable() {
        return this.retryable;
    }
}

