/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.HttpServerConfiguration;
import org.apache.bookkeeper.http.HttpServerLoader;
import org.apache.bookkeeper.http.HttpServiceProvider;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.server.http.BKHttpServiceProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration2.Configuration;

public class HttpService
extends ServerLifecycleComponent {
    public static final String NAME = "http-service";
    private HttpServer server;

    public HttpService(BKHttpServiceProvider provider, BookieConfiguration conf, StatsLogger statsLogger) {
        super(NAME, conf, statsLogger);
        HttpServerLoader.loadHttpServer((Configuration)conf.getServerConf());
        this.server = HttpServerLoader.get();
        Preconditions.checkNotNull((Object)this.server, (Object)"httpServerClass is not configured or it could not be started, please check your configuration and logs");
        this.server.initialize((HttpServiceProvider)provider);
    }

    protected void doStart() {
        ServerConfiguration serverConf = ((BookieConfiguration)this.conf).getServerConf();
        HttpServerConfiguration tlsOption = new HttpServerConfiguration(serverConf.isHttpServerTlsEnable(), serverConf.getHttpServerKeystorePath(), serverConf.getHttpServerKeystorePassword(), serverConf.getHttpServerTrustStorePath(), serverConf.getHttpServerTrustStorePassword());
        this.server.startServer(serverConf.getHttpServerPort(), serverConf.getHttpServerHost(), tlsOption);
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        this.server.stopServer();
    }

    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        if (((BookieConfiguration)this.conf).getServerConf().isHttpServerEnabled()) {
            ComponentInfoPublisher.EndpointInfo endpoint = new ComponentInfoPublisher.EndpointInfo("httpserver", ((BookieConfiguration)this.conf).getServerConf().getHttpServerPort(), ((BookieConfiguration)this.conf).getServerConf().getHttpServerHost(), "http", null, null);
            componentInfoPublisher.publishEndpoint(endpoint);
        }
    }
}

