/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.Validate;

@ThreadSafe
public final class PrefixList {
    private final ImmutableList<String> mInnerList;

    public PrefixList(List<String> prefixList) {
        this.mInnerList = prefixList == null ? ImmutableList.of() : ImmutableList.copyOf(prefixList);
    }

    public PrefixList(String prefixes, String separator) {
        Validate.notNull((Object)separator);
        ArrayList<String> prefixList = new ArrayList<String>(0);
        if (prefixes != null && !prefixes.trim().isEmpty()) {
            String[] candidates;
            for (String prefix : candidates = prefixes.trim().split(separator)) {
                String trimmed = prefix.trim();
                if (trimmed.isEmpty()) continue;
                prefixList.add(trimmed);
            }
        }
        this.mInnerList = ImmutableList.copyOf(prefixList);
    }

    public ImmutableList<String> getList() {
        return this.mInnerList;
    }

    public boolean inList(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return false;
        }
        for (String prefix : this.mInnerList) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean outList(String path) {
        return !this.inList(path);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (String prefix : this.mInnerList) {
            s.append(prefix).append(";");
        }
        return s.toString();
    }
}

