/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.grpc.LoadJobPOptions;
import alluxio.job.JobRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LoadJobRequest
implements JobRequest {
    private static final String TYPE = "load";
    private static final long serialVersionUID = -4100882786127020489L;
    private final String mPath;
    private final LoadJobPOptions mOptions;

    public LoadJobRequest(@JsonProperty(value="path") String path, @JsonProperty(value="loadJobPOptions") LoadJobPOptions options) {
        this.mPath = (String)Preconditions.checkNotNull((Object)path, (Object)"The file path cannot be null");
        this.mOptions = (LoadJobPOptions)Preconditions.checkNotNull((Object)options, (Object)"The load job options cannot be null");
    }

    public String getPath() {
        return this.mPath;
    }

    public LoadJobPOptions getOptions() {
        return this.mOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Path", (Object)this.mPath).add("Options", (Object)this.mOptions).toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

