/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.aggregator;

import alluxio.metrics.Metric;
import alluxio.metrics.MultiValueMetricsAggregator;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SingleTagValueAggregator
implements MultiValueMetricsAggregator {
    private final String mAggregationName;
    private final String mMetricName;
    private final String mTagName;
    private Map<String, Long> mAggregates;

    public SingleTagValueAggregator(String aggregationName, String metricName, String tagName) {
        Preconditions.checkNotNull((Object)aggregationName, (Object)"aggregationName");
        Preconditions.checkNotNull((Object)metricName, (Object)"metricName");
        Preconditions.checkNotNull((Object)tagName, (Object)"tagName");
        this.mAggregationName = aggregationName;
        this.mMetricName = metricName;
        this.mTagName = tagName;
        this.mAggregates = new HashMap<String, Long>();
    }

    @Override
    public String getFilterMetricName() {
        return this.mMetricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> updateValues(Set<Metric> set) {
        HashMap<String, Long> updated = new HashMap<String, Long>();
        for (Metric metric : set) {
            Map<String, String> tags = metric.getTags();
            if (!tags.containsKey(this.mTagName)) continue;
            String ufsName = Metric.getMetricNameWithTags(this.mAggregationName, this.mTagName, tags.get(this.mTagName));
            long value = updated.getOrDefault(ufsName, 0L);
            updated.put(ufsName, (long)((double)value + metric.getValue()));
        }
        SingleTagValueAggregator singleTagValueAggregator = this;
        synchronized (singleTagValueAggregator) {
            this.mAggregates = updated;
        }
        return Collections.unmodifiableMap(this.mAggregates);
    }

    @Override
    public long getValue(String name) {
        return this.mAggregates.getOrDefault(name, 0L);
    }
}

