/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.proto;

import alluxio.collections.IndexDefinition;
import alluxio.collections.IndexedSet;
import alluxio.proto.meta.Block;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

public class BlockLocationUtils {
    private static final IndexDefinition<Block.BlockLocation, Block.BlockLocation> OBJECT_INDEX = IndexDefinition.ofUnique(b -> b);
    private static final IndexDefinition<Block.BlockLocation, Long> WORKER_ID_INDEX = IndexDefinition.ofNonUnique(Block.BlockLocation::getWorkerId);
    private static final IndexedSet<Block.BlockLocation> BLOCK_LOCATION_CACHE = new IndexedSet<Block.BlockLocation>(OBJECT_INDEX, WORKER_ID_INDEX);
    private static final Set<String> VALID_MEDIUM_TYPE_VALUES = Sets.newHashSet((Object[])new String[]{"MEM", "HDD", "SSD"});

    public static Block.BlockLocation getCached(long workerId, String tierAlias, String mediumType) {
        Block.BlockLocation location = Block.BlockLocation.newBuilder().setWorkerId(workerId).setTier(tierAlias).setMediumType(mediumType).build();
        return BlockLocationUtils.getCached(location);
    }

    public static Block.BlockLocation getCached(Block.BlockLocation blockLocation) {
        Preconditions.checkState((boolean)VALID_MEDIUM_TYPE_VALUES.contains(blockLocation.getTier()), (String)"TierAlias must be one of {MEM, HDD and SSD} but got %s", (Object)blockLocation.getTier());
        Preconditions.checkState((boolean)VALID_MEDIUM_TYPE_VALUES.contains(blockLocation.getMediumType()), (String)"MediumType must be one of {MEM, HDD and SSD} but got %s", (Object)blockLocation.getMediumType());
        BLOCK_LOCATION_CACHE.add(blockLocation);
        return BLOCK_LOCATION_CACHE.getFirstByField(OBJECT_INDEX, blockLocation);
    }

    public static void evictByWorkerId(long workerId) {
        BLOCK_LOCATION_CACHE.removeByField(WORKER_ID_INDEX, workerId);
    }

    public static int getCachedBlockLocationSize() {
        return BLOCK_LOCATION_CACHE.size();
    }
}

