/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.webui;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class UIFileBlockInfo {
    private final List<String> mLocations = new ArrayList<String>();
    private final Set<String> mTierAliases = new HashSet<String>();
    private final long mId;
    private final long mBlockLength;
    private final long mLastAccessTimeMs;
    private final boolean mIsInHighestTier;

    public UIFileBlockInfo(FileBlockInfo fileBlockInfo, AlluxioConfiguration alluxioConfiguration) {
        Preconditions.checkNotNull((Object)fileBlockInfo, (Object)"fileBlockInfo");
        this.mId = fileBlockInfo.getBlockInfo().getBlockId();
        this.mBlockLength = fileBlockInfo.getBlockInfo().getLength();
        this.mLastAccessTimeMs = -1L;
        this.addLocations(fileBlockInfo);
        for (BlockLocation location : fileBlockInfo.getBlockInfo().getLocations()) {
            this.mTierAliases.add(location.getTierAlias());
        }
        this.mIsInHighestTier = this.mTierAliases.contains(alluxioConfiguration.getString(PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS));
    }

    public UIFileBlockInfo(long blockId, long blockLength, long blockLastAccessTimeMs, String tierAlias, AlluxioConfiguration alluxioConfiguration) {
        this.mId = blockId;
        this.mBlockLength = blockLength;
        this.mLastAccessTimeMs = blockLastAccessTimeMs;
        this.mTierAliases.add(tierAlias);
        this.mIsInHighestTier = this.mTierAliases.contains(alluxioConfiguration.getString(PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS));
    }

    private void addLocations(FileBlockInfo fileBlockInfo) {
        HashSet<String> locations = new HashSet<String>();
        for (BlockLocation blockLocation : fileBlockInfo.getBlockInfo().getLocations()) {
            locations.add(blockLocation.getWorkerAddress().getHost());
        }
        for (String string : fileBlockInfo.getUfsLocations()) {
            locations.add(HostAndPort.fromString((String)string).getHost());
        }
        this.mLocations.addAll(locations);
    }

    public boolean isInTier(String tierAlias) {
        return this.mTierAliases.contains(tierAlias);
    }

    public long getBlockLength() {
        return this.mBlockLength;
    }

    public long getID() {
        return this.mId;
    }

    public long getLastAccessTimeMs() {
        return this.mLastAccessTimeMs;
    }

    public List<String> getLocations() {
        return this.mLocations;
    }

    public boolean getIsInHighestTier() {
        return this.mIsInHighestTier;
    }
}

