/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.TtlAction;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.wire.FileBlockInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileInfo
implements Serializable {
    private static final long serialVersionUID = 3086599355791696602L;
    private long mFileId;
    private String mName = "";
    private String mPath = "";
    private String mUfsPath = "";
    private long mLength;
    private long mBlockSizeBytes;
    private long mCreationTimeMs;
    private boolean mCompleted;
    private boolean mFolder;
    private boolean mPinned;
    private Set<String> mMediumTypes = new HashSet<String>();
    private boolean mCacheable;
    private boolean mPersisted;
    private ArrayList<Long> mBlockIds = new ArrayList();
    private int mInMemoryPercentage;
    private long mLastModificationTimeMs;
    private long mLastAccessTimeMs;
    private long mTtl;
    private TtlAction mTtlAction;
    private String mOwner = "";
    private String mGroup = "";
    private int mMode;
    private String mPersistenceState = "";
    private boolean mMountPoint;
    private ArrayList<FileBlockInfo> mFileBlockInfoList = new ArrayList();
    private Map<Long, FileBlockInfo> mFileBlockInfoMap = new HashMap<Long, FileBlockInfo>();
    private long mMountId;
    private int mReplicationMax;
    private int mReplicationMin;
    private int mInAlluxioPercentage;
    private String mUfsFingerprint = "";
    private AccessControlList mAcl = AccessControlList.EMPTY_ACL;
    private DefaultAccessControlList mDefaultAcl = DefaultAccessControlList.EMPTY_DEFAULT_ACL;
    private Map<String, byte[]> mXAttr;

    public long getFileId() {
        return this.mFileId;
    }

    public String getName() {
        return this.mName;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getUfsPath() {
        return this.mUfsPath;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public long getCreationTimeMs() {
        return this.mCreationTimeMs;
    }

    public boolean isCompleted() {
        return this.mCompleted;
    }

    public boolean isFolder() {
        return this.mFolder;
    }

    public boolean isPinned() {
        return this.mPinned;
    }

    public boolean isCacheable() {
        return this.mCacheable;
    }

    public boolean isPersisted() {
        return this.mPersisted;
    }

    public List<Long> getBlockIds() {
        return this.mBlockIds;
    }

    public int getInMemoryPercentage() {
        return this.mInMemoryPercentage;
    }

    public int getInAlluxioPercentage() {
        return this.mInAlluxioPercentage;
    }

    public long getLastModificationTimeMs() {
        return this.mLastModificationTimeMs;
    }

    public long getLastAccessTimeMs() {
        return this.mLastAccessTimeMs;
    }

    public long getTtl() {
        return this.mTtl;
    }

    public TtlAction getTtlAction() {
        return this.mTtlAction;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public int getMode() {
        return this.mMode;
    }

    public String getPersistenceState() {
        return this.mPersistenceState;
    }

    public boolean isMountPoint() {
        return this.mMountPoint;
    }

    public List<FileBlockInfo> getFileBlockInfos() {
        return this.mFileBlockInfoList;
    }

    public FileBlockInfo getFileBlockInfo(long blockId) {
        return this.mFileBlockInfoMap.get(blockId);
    }

    public int getReplicationMax() {
        return this.mReplicationMax;
    }

    public int getReplicationMin() {
        return this.mReplicationMin;
    }

    public long getMountId() {
        return this.mMountId;
    }

    public String getUfsFingerprint() {
        return this.mUfsFingerprint;
    }

    public AccessControlList getAcl() {
        return this.mAcl;
    }

    public DefaultAccessControlList getDefaultAcl() {
        return this.mDefaultAcl;
    }

    public List<String> convertAclToStringEntries() {
        return this.mAcl == null ? new ArrayList() : this.mAcl.toStringEntries();
    }

    public List<String> convertDefaultAclToStringEntries() {
        return this.mDefaultAcl == null ? new ArrayList() : this.mDefaultAcl.toStringEntries();
    }

    public Set<String> getMediumTypes() {
        return this.mMediumTypes;
    }

    @Nullable
    public Map<String, byte[]> getXAttr() {
        return this.mXAttr;
    }

    public FileInfo setFileId(long fileId) {
        this.mFileId = fileId;
        return this;
    }

    public FileInfo setName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.mName = name;
        return this;
    }

    public FileInfo setPath(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        this.mPath = path;
        return this;
    }

    public FileInfo setUfsPath(String ufsPath) {
        Preconditions.checkNotNull((Object)ufsPath, (Object)"ufsPath");
        this.mUfsPath = ufsPath;
        return this;
    }

    public FileInfo setLength(long length) {
        this.mLength = length;
        return this;
    }

    public FileInfo setBlockSizeBytes(long blockSizeBytes) {
        this.mBlockSizeBytes = blockSizeBytes;
        return this;
    }

    public FileInfo setCreationTimeMs(long creationTimeMs) {
        this.mCreationTimeMs = creationTimeMs;
        return this;
    }

    public FileInfo setCompleted(boolean completed) {
        this.mCompleted = completed;
        return this;
    }

    public FileInfo setFolder(boolean folder) {
        this.mFolder = folder;
        return this;
    }

    public FileInfo setPinned(boolean pinned) {
        this.mPinned = pinned;
        return this;
    }

    public FileInfo setCacheable(boolean cacheable) {
        this.mCacheable = cacheable;
        return this;
    }

    public FileInfo setPersisted(boolean persisted) {
        this.mPersisted = persisted;
        return this;
    }

    public FileInfo setBlockIds(List<Long> blockIds) {
        Preconditions.checkNotNull(blockIds, (Object)"blockIds");
        this.mBlockIds = new ArrayList<Long>(blockIds);
        return this;
    }

    public FileInfo setInMemoryPercentage(int inMemoryPercentage) {
        this.mInMemoryPercentage = inMemoryPercentage;
        return this;
    }

    public FileInfo setInAlluxioPercentage(int inAlluxioPercentage) {
        this.mInAlluxioPercentage = inAlluxioPercentage;
        return this;
    }

    public FileInfo setLastModificationTimeMs(long lastModificationTimeMs) {
        this.mLastModificationTimeMs = lastModificationTimeMs;
        return this;
    }

    public FileInfo setLastAccessTimeMs(long lastAccessTimeMs) {
        this.mLastAccessTimeMs = lastAccessTimeMs;
        return this;
    }

    public FileInfo setTtl(long ttl) {
        this.mTtl = ttl;
        return this;
    }

    public FileInfo setTtlAction(TtlAction ttlAction) {
        this.mTtlAction = ttlAction;
        return this;
    }

    public FileInfo setOwner(String owner) {
        Preconditions.checkNotNull((Object)owner, (Object)"owner");
        this.mOwner = owner;
        return this;
    }

    public FileInfo setGroup(String group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        this.mGroup = group;
        return this;
    }

    public FileInfo setMode(int mode) {
        this.mMode = mode;
        return this;
    }

    public FileInfo setPersistenceState(String persistenceState) {
        Preconditions.checkNotNull((Object)persistenceState, (Object)"persistenceState");
        this.mPersistenceState = persistenceState;
        return this;
    }

    public FileInfo setMountPoint(boolean mountPoint) {
        this.mMountPoint = mountPoint;
        return this;
    }

    public FileInfo setFileBlockInfos(List<FileBlockInfo> fileBlockInfos) {
        this.mFileBlockInfoList = new ArrayList<FileBlockInfo>(fileBlockInfos);
        for (FileBlockInfo info : this.mFileBlockInfoList) {
            this.mFileBlockInfoMap.put(info.getBlockInfo().getBlockId(), info);
        }
        return this;
    }

    public FileInfo setReplicationMax(int replicationMax) {
        this.mReplicationMax = replicationMax;
        return this;
    }

    public FileInfo setReplicationMin(int replicationMin) {
        this.mReplicationMin = replicationMin;
        return this;
    }

    public FileInfo setMountId(long mountId) {
        this.mMountId = mountId;
        return this;
    }

    public FileInfo setUfsFingerprint(String ufsFingerprint) {
        this.mUfsFingerprint = ufsFingerprint;
        return this;
    }

    public FileInfo setAcl(AccessControlList acl) {
        this.mAcl = acl;
        return this;
    }

    public FileInfo setDefaultAcl(DefaultAccessControlList defaultAcl) {
        this.mDefaultAcl = defaultAcl;
        return this;
    }

    public FileInfo setMediumTypes(Set<String> mediumTypes) {
        this.mMediumTypes = mediumTypes;
        return this;
    }

    public FileInfo setXAttr(Map<String, byte[]> xAttr) {
        this.mXAttr = xAttr;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo that = (FileInfo)o;
        return this.mFileId == that.mFileId && this.mName.equals(that.mName) && this.mPath.equals(that.mPath) && this.mUfsPath.equals(that.mUfsPath) && this.mLength == that.mLength && this.mBlockSizeBytes == that.mBlockSizeBytes && this.mCreationTimeMs == that.mCreationTimeMs && this.mCompleted == that.mCompleted && this.mFolder == that.mFolder && this.mPinned == that.mPinned && this.mCacheable == that.mCacheable && this.mPersisted == that.mPersisted && this.mBlockIds.equals(that.mBlockIds) && this.mInMemoryPercentage == that.mInMemoryPercentage && this.mLastModificationTimeMs == that.mLastModificationTimeMs && this.mTtl == that.mTtl && this.mLastAccessTimeMs == that.mLastAccessTimeMs && this.mOwner.equals(that.mOwner) && this.mGroup.equals(that.mGroup) && this.mMode == that.mMode && this.mPersistenceState.equals(that.mPersistenceState) && this.mMountPoint == that.mMountPoint && this.mReplicationMax == that.mReplicationMax && this.mReplicationMin == that.mReplicationMin && this.mFileBlockInfoList.equals(that.mFileBlockInfoList) && this.mTtlAction == that.mTtlAction && this.mMountId == that.mMountId && this.mInAlluxioPercentage == that.mInAlluxioPercentage && this.mUfsFingerprint.equals(that.mUfsFingerprint) && Objects.equal((Object)this.mAcl, (Object)that.mAcl) && Objects.equal((Object)this.mDefaultAcl, (Object)that.mDefaultAcl) && Objects.equal(this.mMediumTypes, that.mMediumTypes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mFileId, this.mName, this.mPath, this.mUfsPath, this.mLength, this.mBlockSizeBytes, this.mCreationTimeMs, this.mCompleted, this.mFolder, this.mPinned, this.mCacheable, this.mPersisted, this.mBlockIds, this.mInMemoryPercentage, this.mLastModificationTimeMs, this.mLastAccessTimeMs, this.mTtl, this.mOwner, this.mGroup, this.mMode, this.mReplicationMax, this.mReplicationMin, this.mPersistenceState, this.mMountPoint, this.mFileBlockInfoList, this.mTtlAction, this.mInAlluxioPercentage, this.mUfsFingerprint, this.mAcl, this.mDefaultAcl, this.mMediumTypes});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileId", this.mFileId).add("name", (Object)this.mName).add("path", (Object)this.mPath).add("ufsPath", (Object)this.mUfsPath).add("length", this.mLength).add("blockSizeBytes", this.mBlockSizeBytes).add("creationTimeMs", this.mCreationTimeMs).add("completed", this.mCompleted).add("folder", this.mFolder).add("pinned", this.mPinned).add("pinnedlocation", this.mMediumTypes).add("cacheable", this.mCacheable).add("persisted", this.mPersisted).add("blockIds", this.mBlockIds).add("inMemoryPercentage", this.mInMemoryPercentage).add("lastModificationTimesMs", this.mLastModificationTimeMs).add("ttl", this.mTtl).add("lastAccessTimesMs", this.mLastAccessTimeMs).add("ttlAction", (Object)this.mTtlAction).add("owner", (Object)this.mOwner).add("group", (Object)this.mGroup).add("mode", this.mMode).add("persistenceState", (Object)this.mPersistenceState).add("mountPoint", this.mMountPoint).add("replicationMax", this.mReplicationMax).add("replicationMin", this.mReplicationMin).add("fileBlockInfos", this.mFileBlockInfoList).add("mountId", this.mMountId).add("inAlluxioPercentage", this.mInAlluxioPercentage).add("ufsFingerprint", (Object)this.mUfsFingerprint).add("acl", (Object)this.mAcl.toString()).add("defaultAcl", (Object)this.mDefaultAcl.toString()).add("xattr", (Object)("[" + (this.mXAttr == null ? null : this.mXAttr.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (entry.getValue() == null ? null : new String((byte[])entry.getValue()))).collect(Collectors.joining(", "))) + "]")).toString();
    }
}

