/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.Cancelable;
import alluxio.client.WriteType;
import alluxio.client.block.stream.BlockWorkerDataWriter;
import alluxio.client.block.stream.GrpcDataWriter;
import alluxio.client.block.stream.LocalFileDataWriter;
import alluxio.client.block.stream.UfsFallbackLocalFileDataWriter;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.RequestType;
import alluxio.util.CommonUtils;
import alluxio.util.network.NettyUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataWriter
extends Closeable,
Cancelable {
    public Optional<String> getUfsContentHash();

    public void writeChunk(ByteBuf var1) throws IOException;

    public void flush() throws IOException;

    public int chunkSize();

    public long pos();

    @ThreadSafe
    public static class Factory {
        public static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        private Factory() {
        }

        public static DataWriter create(FileSystemContext context, long blockId, long blockSize, WorkerNetAddress address, OutStreamOptions options) throws IOException {
            AlluxioConfiguration alluxioConf = context.getClusterConf();
            boolean shortCircuit = alluxioConf.getBoolean(PropertyKey.USER_SHORT_CIRCUIT_ENABLED);
            boolean shortCircuitPreferred = alluxioConf.getBoolean(PropertyKey.USER_SHORT_CIRCUIT_PREFERRED);
            boolean ufsFallbackEnabled = options.getWriteType() == WriteType.ASYNC_THROUGH && alluxioConf.getBoolean(PropertyKey.USER_FILE_UFS_TIER_ENABLED);
            boolean workerIsLocal = CommonUtils.isLocalHost((WorkerNetAddress)address, (AlluxioConfiguration)alluxioConf);
            if (workerIsLocal && context.hasProcessLocalWorker() && !ufsFallbackEnabled) {
                LOG.debug("Creating worker process local output stream for block {} @ {}", (Object)blockId, (Object)address);
                return BlockWorkerDataWriter.create(context, blockId, blockSize, options);
            }
            LOG.debug("Doesn't create worker process local output stream for block {} @ {} (data locates in local worker: {}, client locates in local worker process: {}, ufs fallback enabled: {})", new Object[]{blockId, address, workerIsLocal, context.hasProcessLocalWorker(), ufsFallbackEnabled});
            boolean domainSocketSupported = NettyUtils.isDomainSocketSupported((WorkerNetAddress)address);
            if (workerIsLocal && shortCircuit && (shortCircuitPreferred || !domainSocketSupported)) {
                if (ufsFallbackEnabled) {
                    LOG.info("Creating UFS-fallback short circuit output stream for block {} @ {}", (Object)blockId, (Object)address);
                    return UfsFallbackLocalFileDataWriter.create(context, address, blockId, blockSize, options);
                }
                LOG.debug("Creating short circuit output stream for block {} @ {}", (Object)blockId, (Object)address);
                return LocalFileDataWriter.create(context, address, blockId, blockSize, options);
            }
            LOG.debug("Creating gRPC output stream for block {} @ {} from client {} (data locates in local worker: {}, shortCircuitEnabled: {}, shortCircuitPreferred: {}, domainSocketSupported: {})", new Object[]{blockId, address, NetworkAddressUtils.getClientHostName((AlluxioConfiguration)alluxioConf), workerIsLocal, shortCircuit, shortCircuitPreferred, domainSocketSupported});
            return GrpcDataWriter.create(context, address, blockId, blockSize, RequestType.ALLUXIO_BLOCK, options);
        }
    }
}

