/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheManagerWithShadowCache;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.ShadowCacheManager;
import alluxio.client.quota.CacheScope;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MultipleBloomShadowCacheManager
implements ShadowCacheManager {
    private final int mNumBloomFilter;
    private final long mBloomFilterExpectedInsertions;
    private final AtomicReferenceArray<BloomFilter<PageId>> mSegmentBloomFilters;
    private final AtomicIntegerArray mObjEachBloomFilter;
    private final AtomicLongArray mByteEachBloomFilter;
    private final ScheduledExecutorService mScheduler = Executors.newScheduledThreadPool(0);
    private int mCurrentSegmentFilterIndex = 0;
    private BloomFilter<PageId> mWorkingSetBloomFilter;
    private long mShadowCachePages = 0L;
    private long mShadowCacheBytes = 0L;
    private double mAvgPageSize;
    private final AtomicLong mShadowCachePageRead = new AtomicLong(0L);
    private final AtomicLong mShadowCachePageHit = new AtomicLong(0L);
    private final AtomicLong mShadowCacheByteRead = new AtomicLong(0L);
    private final AtomicLong mShadowCacheByteHit = new AtomicLong(0L);

    public MultipleBloomShadowCacheManager(AlluxioConfiguration conf) {
        long windowMs = conf.getMs(PropertyKey.USER_CLIENT_CACHE_SHADOW_WINDOW);
        this.mNumBloomFilter = conf.getInt(PropertyKey.USER_CLIENT_CACHE_SHADOW_BLOOMFILTER_NUM);
        long perBloomFilterMemoryOverhead = conf.getBytes(PropertyKey.USER_CLIENT_CACHE_SHADOW_MEMORY_OVERHEAD) / (long)(this.mNumBloomFilter + 1);
        this.mBloomFilterExpectedInsertions = (long)((double)(-perBloomFilterMemoryOverhead * 8L) * Math.log(2.0) * Math.log(2.0) / Math.log(0.03));
        this.mObjEachBloomFilter = new AtomicIntegerArray(new int[this.mNumBloomFilter]);
        this.mByteEachBloomFilter = new AtomicLongArray(new long[this.mNumBloomFilter]);
        this.mSegmentBloomFilters = new AtomicReferenceArray<BloomFilter>(new BloomFilter[this.mNumBloomFilter]);
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            this.mSegmentBloomFilters.set(i, (BloomFilter<PageId>)BloomFilter.create((Funnel)CacheManagerWithShadowCache.PageIdFunnel.FUNNEL, (long)this.mBloomFilterExpectedInsertions));
        }
        this.mWorkingSetBloomFilter = BloomFilter.create((Funnel)CacheManagerWithShadowCache.PageIdFunnel.FUNNEL, (long)this.mBloomFilterExpectedInsertions);
        this.mScheduler.scheduleAtFixedRate(this::switchBloomFilter, 0L, windowMs / (long)this.mNumBloomFilter, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean put(PageId pageId, int size, CacheScope scope) {
        this.updateBloomFilterAndWorkingSet(pageId, size);
        return true;
    }

    @Override
    public int get(PageId pageId, int bytesToRead, CacheScope scope) {
        boolean seen = false;
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            seen |= this.mSegmentBloomFilters.get(i).mightContain((Object)pageId);
        }
        if (seen) {
            this.mShadowCachePageHit.getAndIncrement();
            this.mShadowCacheByteHit.getAndAdd(bytesToRead);
        }
        this.mShadowCachePageRead.getAndIncrement();
        this.mShadowCacheByteRead.getAndAdd(bytesToRead);
        return seen ? bytesToRead : 0;
    }

    private void updateBloomFilterAndWorkingSet(PageId pageId, int pageLength) {
        int filterIndex = this.mCurrentSegmentFilterIndex;
        BloomFilter<PageId> bf = this.mSegmentBloomFilters.get(filterIndex);
        if (!bf.mightContain((Object)pageId)) {
            bf.put((Object)pageId);
            this.mObjEachBloomFilter.getAndIncrement(filterIndex);
            this.mByteEachBloomFilter.getAndAdd(filterIndex, pageLength);
            this.mWorkingSetBloomFilter.put((Object)pageId);
            this.updateWorkingSetSize();
        }
    }

    @Override
    public void updateWorkingSetSize() {
        this.updateAvgPageSize();
        try {
            this.mShadowCachePages = (int)this.mWorkingSetBloomFilter.approximateElementCount();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        this.mShadowCacheBytes = (long)((double)this.mShadowCachePages * this.mAvgPageSize);
    }

    private void updateAvgPageSize() {
        int nInsert = 0;
        long nByte = 0L;
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            nInsert += this.mObjEachBloomFilter.get(i);
            nByte += this.mByteEachBloomFilter.get(i);
        }
        this.mAvgPageSize = nInsert == 0 ? 0.0 : (double)nByte / (double)nInsert;
    }

    @Override
    public boolean delete(PageId pageId) {
        return false;
    }

    @Override
    public void aging() {
        this.switchBloomFilter();
    }

    private void switchBloomFilter() {
        this.updateAvgPageSize();
        this.mCurrentSegmentFilterIndex = (this.mCurrentSegmentFilterIndex + 1) % this.mNumBloomFilter;
        this.mSegmentBloomFilters.set(this.mCurrentSegmentFilterIndex, (BloomFilter<PageId>)BloomFilter.create((Funnel)CacheManagerWithShadowCache.PageIdFunnel.FUNNEL, (long)this.mBloomFilterExpectedInsertions));
        this.mObjEachBloomFilter.set(this.mCurrentSegmentFilterIndex, 0);
        this.mByteEachBloomFilter.set(this.mCurrentSegmentFilterIndex, 0L);
        this.mWorkingSetBloomFilter = BloomFilter.create((Funnel)CacheManagerWithShadowCache.PageIdFunnel.FUNNEL, (long)this.mBloomFilterExpectedInsertions);
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            this.mWorkingSetBloomFilter.putAll(this.mSegmentBloomFilters.get(i));
        }
    }

    @Override
    public void stopUpdate() {
        this.mScheduler.shutdown();
    }

    @Override
    public long getShadowCachePages() {
        return this.mShadowCachePages;
    }

    @Override
    public long getShadowCachePages(CacheScope scope) {
        return 0L;
    }

    @Override
    public long getShadowCacheBytes() {
        return this.mShadowCacheBytes;
    }

    @Override
    public long getShadowCacheBytes(CacheScope scope) {
        return 0L;
    }

    @Override
    public long getShadowCachePageRead() {
        return this.mShadowCachePageRead.get();
    }

    @Override
    public long getShadowCachePageHit() {
        return this.mShadowCachePageHit.get();
    }

    @Override
    public long getShadowCacheByteRead() {
        return this.mShadowCacheByteRead.get();
    }

    @Override
    public long getShadowCacheByteHit() {
        return this.mShadowCacheByteHit.get();
    }

    @Override
    public double getFalsePositiveRatio() {
        return this.mWorkingSetBloomFilter.expectedFpp();
    }
}

