/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.evictor.CacheEvictorOptions;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FIFOCacheEvictor
implements CacheEvictor {
    private final LinkedList<PageId> mQueue = new LinkedList();

    public FIFOCacheEvictor(CacheEvictorOptions options) {
    }

    @Override
    public void updateOnGet(PageId pageId) {
    }

    @Override
    public void updateOnPut(PageId pageId) {
        this.mQueue.add(pageId);
    }

    @Override
    public void updateOnDelete(PageId pageId) {
        int idx = this.mQueue.indexOf(pageId);
        if (idx >= 0) {
            this.mQueue.remove(idx);
        }
    }

    @Override
    public PageId evict() {
        return this.mQueue.peek();
    }

    @Override
    @Nullable
    public PageId evictMatching(Predicate<PageId> criterion) {
        for (PageId candidate : this.mQueue) {
            if (!criterion.test(candidate)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public void reset() {
        this.mQueue.clear();
    }
}

