/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.registry;

import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@FunctionalInterface
public interface MultiCollector {
    public MetricSnapshots collect();

    default public MetricSnapshots collect(Predicate<String> includedNames) {
        MetricSnapshots allSnapshots = this.collect();
        MetricSnapshots.Builder result = MetricSnapshots.builder();
        for (MetricSnapshot snapshot : allSnapshots) {
            if (!includedNames.test(snapshot.getMetadata().getPrometheusName())) continue;
            result.metricSnapshot(snapshot);
        }
        return result.build();
    }

    default public List<String> getPrometheusNames() {
        return this.collect().stream().map(snapshot -> snapshot.getMetadata().getPrometheusName()).collect(Collectors.toList());
    }
}

