/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.payment;

import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.payment.IBAN;
import io.codearte.jfairy.producer.payment.IBANProperties;
import io.codearte.jfairy.producer.payment.IBANProvider;
import java.math.BigInteger;
import java.util.IllegalFormatCodePointException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.CountryCode;
import org.iban4j.Iban;
import org.iban4j.bban.BbanEntryType;
import org.iban4j.bban.BbanStructure;
import org.iban4j.bban.BbanStructureEntry;

public class DefaultIBANProvider
implements IBANProvider {
    protected BaseProducer baseProducer;
    protected CountryCode countryCode;
    protected String accountNumber;
    protected String bankCode;
    protected String branchCode;
    protected String nationalCheckDigit;

    @Inject
    public DefaultIBANProvider(BaseProducer baseProducer, IBANProperties.Property ... properties) {
        this.baseProducer = baseProducer;
        for (IBANProperties.Property property : properties) {
            property.apply(this);
        }
    }

    @Override
    public IBAN get() {
        try {
            this.fillCountryCode();
            this.fillAccountNumber();
            this.fillBankCode();
            this.fillBranchCode();
            this.nationalCheckDigit = this.nationalCheckDigit(this.nationalCheckDigit);
            Iban iban = new Iban.Builder().countryCode(this.countryCode).bankCode(this.bankCode).branchCode(this.branchCode).nationalCheckDigit(this.nationalCheckDigit).accountNumber(this.accountNumber).build();
            String identificationNumber = iban.getIdentificationNumber();
            String checkDigit = iban.getCheckDigit();
            String accountType = iban.getAccountType();
            String bban = iban.getBban();
            String ownerAccountType = iban.getOwnerAccountType();
            String ibanNumber = iban.toString();
            return new IBAN(this.accountNumber, identificationNumber, this.branchCode, checkDigit, accountType, this.bankCode, bban, this.countryCode.getName(), this.nationalCheckDigit, ownerAccountType, ibanNumber);
        }
        catch (IllegalFormatCodePointException e) {
            throw new IllegalArgumentException("Invalid iban " + e.getMessage(), e);
        }
    }

    @Override
    public String nationalCheckDigit(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this.generateRequiredData(BbanEntryType.national_check_digit);
        }
        return value;
    }

    @Override
    public void fillNationalCheckDigit() {
        if (StringUtils.isBlank((CharSequence)this.nationalCheckDigit)) {
            this.nationalCheckDigit = this.generateRequiredData(BbanEntryType.national_check_digit);
        }
    }

    @Override
    public void fillBranchCode() {
        if (StringUtils.isBlank((CharSequence)this.branchCode)) {
            this.branchCode = this.generateRequiredData(BbanEntryType.branch_code);
        }
    }

    @Override
    public void fillBankCode() {
        if (StringUtils.isBlank((CharSequence)this.bankCode)) {
            this.bankCode = this.generateRequiredData(BbanEntryType.bank_code);
        }
    }

    @Override
    public void fillAccountNumber() {
        if (StringUtils.isBlank((CharSequence)this.accountNumber)) {
            this.accountNumber = this.generateRequiredData(BbanEntryType.account_number);
        }
    }

    @Override
    public void fillCountryCode() {
        if (this.countryCode == null) {
            this.countryCode = CountryCode.PL;
        }
    }

    @Override
    public String generateRequiredData(BbanEntryType type) {
        String value = "";
        BbanStructureEntry entry = DefaultIBANProvider.extractBbanEntry(this.countryCode, type);
        if (entry != null) {
            int length = entry.getLength();
            value = "" + this.baseProducer.randomBetween(0L, BigInteger.TEN.pow(length).longValue() - 1L);
            value = StringUtils.leftPad((String)value, (int)length, (String)"0");
        }
        return value;
    }

    @Override
    public void setNationalCheckDigit(String nationalCheckDigit) {
        this.nationalCheckDigit = nationalCheckDigit;
    }

    @Override
    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    @Override
    public void setCountry(String country) {
        this.countryCode = CountryCode.valueOf((String)country);
    }

    @Override
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @Override
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    protected static BbanStructureEntry extractBbanEntry(CountryCode countryCode, BbanEntryType entryType) {
        for (BbanStructureEntry entry : BbanStructure.forCountry((CountryCode)countryCode).getEntries()) {
            if (entry.getEntryType() != entryType) continue;
            return entry;
        }
        return null;
    }
}

