/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.person.locale.de;

import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.person.NationalIdentityCardNumberProvider;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;

public class DeNationalIdentityCardNumberProvider
implements NationalIdentityCardNumberProvider {
    private static final String[] ID_CARD_TYPE_LETTERS = new String[]{"L", "M", "N", "P", "R", "T", "V", "W", "X", "Y"};
    private static final String VALID_NUMBER_PATTERN = "^[LMNPRTVWXY][0-9]{8}$";
    private final BaseProducer baseProducer;

    @Inject
    public DeNationalIdentityCardNumberProvider(BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
    }

    @Override
    public String get() {
        return this.baseProducer.randomElement(ID_CARD_TYPE_LETTERS) + RandomStringUtils.randomNumeric((int)8);
    }

    public boolean isValid(String nationalIdentityCardNumber) {
        return nationalIdentityCardNumber.matches(VALID_NUMBER_PATTERN);
    }
}

