/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.influxdb.Cancellable;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.internal.FluxCsvParser;
import com.influxdb.query.internal.FluxResultMapper;
import com.influxdb.utils.Arguments;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class AbstractQueryApi
extends AbstractRestClient {
    private static final Logger LOG = Logger.getLogger(AbstractQueryApi.class.getName());
    protected final FluxCsvParser fluxCsvParser = new FluxCsvParser();
    protected final FluxResultMapper resultMapper = new FluxResultMapper();
    protected static final Runnable EMPTY_ACTION = () -> {};
    protected static final String DEFAULT_DIALECT;
    protected static final Consumer<Throwable> ERROR_CONSUMER;

    @Nonnull
    protected RequestBody createBody(@Nullable String dialect, @Nonnull String query) {
        Arguments.checkNonEmpty((String)query, (String)"Flux query");
        JsonObject json = new JsonObject();
        json.addProperty("query", query);
        if (dialect != null && !dialect.isEmpty()) {
            JsonElement dialectJson = (JsonElement)new Gson().fromJson(dialect, JsonElement.class);
            json.add("dialect", dialectJson);
        }
        return this.createBody(json.toString());
    }

    protected void query(@Nonnull Call<ResponseBody> queryCall, @Nonnull FluxCsvParser.FluxResponseConsumer responseConsumer, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        BiConsumer<Cancellable, BufferedSource> consumer = (cancellable, bufferedSource) -> {
            try {
                this.fluxCsvParser.parseFluxResponse((BufferedSource)bufferedSource, (Cancellable)cancellable, responseConsumer);
            }
            catch (IOException e) {
                onError.accept(e);
            }
        };
        this.query(queryCall, consumer, onError, onComplete, asynchronously);
    }

    protected FluxRecordIterator queryIterator(@Nonnull Call<ResponseBody> queryCall) {
        return new FluxRecordIterator(queryCall, ERROR_CONSUMER);
    }

    protected void queryRaw(@Nonnull Call<ResponseBody> queryCall, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        BiConsumer<Cancellable, BufferedSource> consumer = (cancellable, bufferedSource) -> {
            try {
                this.parseFluxResponseToLines(line -> onResponse.accept((Cancellable)cancellable, (String)line), (Cancellable)cancellable, (BufferedSource)bufferedSource);
            }
            catch (IOException e) {
                this.catchOrPropagateException(e, onError);
            }
        };
        this.query(queryCall, consumer, onError, onComplete, asynchronously);
    }

    protected RawIterator queryRawIterator(@Nonnull Call<ResponseBody> queryCall) {
        return new RawIterator(queryCall, ERROR_CONSUMER);
    }

    private void query(@Nonnull Call<ResponseBody> query, @Nonnull BiConsumer<Cancellable, BufferedSource> consumer, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Arguments.checkNotNull(query, (String)"query");
        Arguments.checkNotNull(consumer, (String)"consumer");
        Arguments.checkNotNull(onError, (String)"onError");
        Arguments.checkNotNull((Object)onComplete, (String)"onComplete");
        Arguments.checkNotNull((Object)asynchronously, (String)"asynchronously");
        DefaultCancellable cancellable = new DefaultCancellable();
        Consumer<ResponseBody> bodyConsumer = body -> {
            try {
                BufferedSource source = body.source();
                while (source.isOpen() && !source.exhausted() && !cancellable.wasCancelled) {
                    consumer.accept(cancellable, source);
                }
                if (!cancellable.wasCancelled) {
                    onComplete.run();
                }
            }
            catch (Exception e) {
                this.catchOrPropagateException(e, onError);
            }
            finally {
                body.close();
            }
        };
        this.query(query, bodyConsumer, onError, onComplete, asynchronously);
    }

    private void query(@Nonnull Call<ResponseBody> query, final @Nonnull Consumer<ResponseBody> consumer, final @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Arguments.checkNotNull(query, (String)"query");
        Arguments.checkNotNull(consumer, (String)"consumer");
        Arguments.checkNotNull(onError, (String)"onError");
        Arguments.checkNotNull((Object)onComplete, (String)"onComplete");
        Arguments.checkNotNull((Object)asynchronously, (String)"asynchronously");
        Callback<ResponseBody> callback = new Callback<ResponseBody>(){

            public void onResponse(@Nonnull Call<ResponseBody> call, @Nonnull Response<ResponseBody> response) {
                if (!response.isSuccessful()) {
                    onError.accept(AbstractQueryApi.this.responseToError(response));
                    return;
                }
                ResponseBody body = (ResponseBody)response.body();
                if (body == null) {
                    return;
                }
                consumer.accept(body);
            }

            public void onFailure(@Nonnull Call<ResponseBody> call, @Nonnull Throwable throwable) {
                onError.accept(throwable);
            }
        };
        LOG.log(Level.FINEST, "Prepared query {0}, asynchronously {1}", new Object[]{query, asynchronously});
        if (asynchronously.booleanValue()) {
            query.enqueue((Callback)callback);
        } else {
            try {
                Response response = query.execute();
                callback.onResponse(query, response);
            }
            catch (IOException e) {
                this.catchOrPropagateException(e, onError);
            }
        }
    }

    private void parseFluxResponseToLines(@Nonnull Consumer<String> onResponse, @Nonnull Cancellable cancellable, @Nonnull BufferedSource bufferedSource) throws IOException {
        String line = bufferedSource.readUtf8Line();
        while (line != null && !cancellable.isCancelled()) {
            onResponse.accept(line);
            line = bufferedSource.readUtf8Line();
        }
    }

    static {
        HashMap<String, Object> dialect = new HashMap<String, Object>();
        dialect.put("header", true);
        dialect.put("delimiter", ",");
        dialect.put("quoteChar", "\"");
        dialect.put("commentPrefix", "#");
        dialect.put("annotations", new String[]{"datatype", "group", "default"});
        DEFAULT_DIALECT = new GsonBuilder().create().toJson(dialect);
        ERROR_CONSUMER = throwable -> {
            if (throwable instanceof InfluxException) {
                throw (InfluxException)throwable;
            }
            throw new InfluxException((Throwable)throwable);
        };
    }

    protected final class FluxRecordIterator
    implements Iterator<FluxRecord>,
    Closeable,
    Consumer<ResponseBody> {
        private FluxRecord record = null;
        private boolean closed = false;
        private ResponseBody body;
        private CSVParser parser;
        private Iterator<CSVRecord> iterator;
        private final FluxCsvParser.FluxCsvState state = new FluxCsvParser.FluxCsvState();
        private final Consumer<? super Throwable> onError;

        public FluxRecordIterator(@Nonnull Call<ResponseBody> call, Consumer<? super Throwable> onError) {
            this.onError = onError;
            AbstractQueryApi.this.query((Call<ResponseBody>)call, this, (Consumer<? super Throwable>)onError, EMPTY_ACTION, false);
        }

        @Override
        public boolean hasNext() {
            return !this.closed && this.readNext();
        }

        @Override
        public FluxRecord next() {
            return this.record;
        }

        @Override
        public void accept(ResponseBody body) {
            this.body = body;
            InputStreamReader reader = new InputStreamReader(body.source().inputStream(), StandardCharsets.UTF_8);
            try {
                this.parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT);
            }
            catch (IOException e) {
                AbstractQueryApi.this.catchOrPropagateException(e, this.onError);
            }
            this.iterator = this.parser.iterator();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.parser != null) {
                this.parser.close();
            }
            if (this.body != null) {
                this.body.close();
            }
        }

        private boolean readNext() {
            this.record = null;
            while (this.record == null && this.iterator.hasNext()) {
                this.state.csvRecord = this.iterator.next();
                FluxCsvParser.FluxRecordOrTable fluxRecordOrTable = AbstractQueryApi.this.fluxCsvParser.parseNextResponse(this.state);
                if (fluxRecordOrTable.record == null) continue;
                this.record = fluxRecordOrTable.record;
            }
            return this.record != null;
        }
    }

    protected final class RawIterator
    implements Iterator<String>,
    Closeable,
    Consumer<ResponseBody> {
        private String line = null;
        private boolean closed = false;
        private ResponseBody body;
        private BufferedSource source;
        private final Consumer<? super Throwable> onError;

        private RawIterator(@Nonnull Call<ResponseBody> call, Consumer<? super Throwable> onError) {
            this.onError = onError;
            AbstractQueryApi.this.query((Call<ResponseBody>)call, this, (Consumer<? super Throwable>)onError, EMPTY_ACTION, false);
        }

        @Override
        public boolean hasNext() {
            return !this.closed && this.readNext();
        }

        @Override
        public String next() {
            return this.line;
        }

        @Override
        public void accept(ResponseBody body) {
            this.body = body;
            this.source = body.source();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.body != null) {
                this.body.close();
            }
        }

        private boolean readNext() {
            this.line = null;
            try {
                if (!this.closed && this.source.isOpen() && !this.source.exhausted()) {
                    this.line = this.source.readUtf8Line();
                }
            }
            catch (IOException e) {
                AbstractQueryApi.this.catchOrPropagateException(e, this.onError);
            }
            return this.line != null;
        }
    }

    private class DefaultCancellable
    implements Cancellable {
        private volatile boolean wasCancelled = false;

        private DefaultCancellable() {
        }

        @Override
        public void cancel() {
            this.wasCancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.wasCancelled;
        }
    }
}

