/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class PermissionResource {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_ORG = "org";
    @SerializedName(value="org")
    private String org;

    public PermissionResource type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PermissionResource id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="If ID is set that is a permission for a specific resource. if it is not set it is a permission for all resources of that resource type.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PermissionResource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Optional name of the resource if the resource has a name field.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PermissionResource orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(value="If orgID is set that is a permission for all resources owned my that org. if it is not set it is a permission for all resources of that resource type.")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public PermissionResource org(String org) {
        this.org = org;
        return this;
    }

    @ApiModelProperty(value="Optional name of the organization of the organization with orgID.")
    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionResource resource = (PermissionResource)o;
        return Objects.equals((Object)this.type, (Object)resource.type) && Objects.equals(this.id, resource.id) && Objects.equals(this.name, resource.name) && Objects.equals(this.orgID, resource.orgID) && Objects.equals(this.org, resource.org);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.name, this.orgID, this.org});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionResource {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        AUTHORIZATIONS("authorizations"),
        BUCKETS("buckets"),
        DASHBOARDS("dashboards"),
        ORGS("orgs"),
        SOURCES("sources"),
        TASKS("tasks"),
        TELEGRAFS("telegrafs"),
        USERS("users"),
        VARIABLES("variables"),
        SCRAPERS("scrapers"),
        SECRETS("secrets"),
        LABELS("labels"),
        VIEWS("views"),
        DOCUMENTS("documents"),
        NOTIFICATIONRULES("notificationRules"),
        NOTIFICATIONENDPOINTS("notificationEndpoints"),
        CHECKS("checks"),
        DBRP("dbrp"),
        NOTEBOOKS("notebooks"),
        ANNOTATIONS("annotations"),
        REMOTES("remotes"),
        REPLICATIONS("replications");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

