/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.PropertiesMapCopier;
import software.amazon.awssdk.services.glue.model.Property;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthConfiguration> {
    private static final SdkField<Property> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationType").getter(AuthConfiguration.getter(AuthConfiguration::authenticationType)).setter(AuthConfiguration.setter(Builder::authenticationType)).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<Property> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretArn").getter(AuthConfiguration.getter(AuthConfiguration::secretArn)).setter(AuthConfiguration.setter(Builder::secretArn)).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<Map<String, Property>> O_AUTH2_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OAuth2Properties").getter(AuthConfiguration.getter(AuthConfiguration::oAuth2Properties)).setter(AuthConfiguration.setter(Builder::oAuth2Properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> BASIC_AUTHENTICATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BasicAuthenticationProperties").getter(AuthConfiguration.getter(AuthConfiguration::basicAuthenticationProperties)).setter(AuthConfiguration.setter(Builder::basicAuthenticationProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthenticationProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> CUSTOM_AUTHENTICATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomAuthenticationProperties").getter(AuthConfiguration.getter(AuthConfiguration::customAuthenticationProperties)).setter(AuthConfiguration.setter(Builder::customAuthenticationProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAuthenticationProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, SECRET_ARN_FIELD, O_AUTH2_PROPERTIES_FIELD, BASIC_AUTHENTICATION_PROPERTIES_FIELD, CUSTOM_AUTHENTICATION_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Property authenticationType;
    private final Property secretArn;
    private final Map<String, Property> oAuth2Properties;
    private final Map<String, Property> basicAuthenticationProperties;
    private final Map<String, Property> customAuthenticationProperties;

    private AuthConfiguration(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.secretArn = builder.secretArn;
        this.oAuth2Properties = builder.oAuth2Properties;
        this.basicAuthenticationProperties = builder.basicAuthenticationProperties;
        this.customAuthenticationProperties = builder.customAuthenticationProperties;
    }

    public final Property authenticationType() {
        return this.authenticationType;
    }

    public final Property secretArn() {
        return this.secretArn;
    }

    public final boolean hasOAuth2Properties() {
        return this.oAuth2Properties != null && !(this.oAuth2Properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> oAuth2Properties() {
        return this.oAuth2Properties;
    }

    public final boolean hasBasicAuthenticationProperties() {
        return this.basicAuthenticationProperties != null && !(this.basicAuthenticationProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> basicAuthenticationProperties() {
        return this.basicAuthenticationProperties;
    }

    public final boolean hasCustomAuthenticationProperties() {
        return this.customAuthenticationProperties != null && !(this.customAuthenticationProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> customAuthenticationProperties() {
        return this.customAuthenticationProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOAuth2Properties() ? this.oAuth2Properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBasicAuthenticationProperties() ? this.basicAuthenticationProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAuthenticationProperties() ? this.customAuthenticationProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthConfiguration)) {
            return false;
        }
        AuthConfiguration other = (AuthConfiguration)obj;
        return Objects.equals(this.authenticationType(), other.authenticationType()) && Objects.equals(this.secretArn(), other.secretArn()) && this.hasOAuth2Properties() == other.hasOAuth2Properties() && Objects.equals(this.oAuth2Properties(), other.oAuth2Properties()) && this.hasBasicAuthenticationProperties() == other.hasBasicAuthenticationProperties() && Objects.equals(this.basicAuthenticationProperties(), other.basicAuthenticationProperties()) && this.hasCustomAuthenticationProperties() == other.hasCustomAuthenticationProperties() && Objects.equals(this.customAuthenticationProperties(), other.customAuthenticationProperties());
    }

    public final String toString() {
        return ToString.builder((String)"AuthConfiguration").add("AuthenticationType", (Object)this.authenticationType()).add("SecretArn", (Object)this.secretArn()).add("OAuth2Properties", this.hasOAuth2Properties() ? this.oAuth2Properties() : null).add("BasicAuthenticationProperties", this.hasBasicAuthenticationProperties() ? this.basicAuthenticationProperties() : null).add("CustomAuthenticationProperties", this.hasCustomAuthenticationProperties() ? this.customAuthenticationProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationType()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "OAuth2Properties": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Properties()));
            }
            case "BasicAuthenticationProperties": {
                return Optional.ofNullable(clazz.cast(this.basicAuthenticationProperties()));
            }
            case "CustomAuthenticationProperties": {
                return Optional.ofNullable(clazz.cast(this.customAuthenticationProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("OAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
        map.put("BasicAuthenticationProperties", BASIC_AUTHENTICATION_PROPERTIES_FIELD);
        map.put("CustomAuthenticationProperties", CUSTOM_AUTHENTICATION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthConfiguration, T> g) {
        return obj -> g.apply((AuthConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Property authenticationType;
        private Property secretArn;
        private Map<String, Property> oAuth2Properties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Property> basicAuthenticationProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Property> customAuthenticationProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthConfiguration model) {
            this.authenticationType(model.authenticationType);
            this.secretArn(model.secretArn);
            this.oAuth2Properties(model.oAuth2Properties);
            this.basicAuthenticationProperties(model.basicAuthenticationProperties);
            this.customAuthenticationProperties(model.customAuthenticationProperties);
        }

        public final Property.Builder getAuthenticationType() {
            return this.authenticationType != null ? this.authenticationType.toBuilder() : null;
        }

        public final void setAuthenticationType(Property.BuilderImpl authenticationType) {
            this.authenticationType = authenticationType != null ? authenticationType.build() : null;
        }

        @Override
        public final Builder authenticationType(Property authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public final Property.Builder getSecretArn() {
            return this.secretArn != null ? this.secretArn.toBuilder() : null;
        }

        public final void setSecretArn(Property.BuilderImpl secretArn) {
            this.secretArn = secretArn != null ? secretArn.build() : null;
        }

        @Override
        public final Builder secretArn(Property secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Map<String, Property.Builder> getOAuth2Properties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.oAuth2Properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOAuth2Properties(Map<String, Property.BuilderImpl> oAuth2Properties) {
            this.oAuth2Properties = PropertiesMapCopier.copyFromBuilder(oAuth2Properties);
        }

        @Override
        public final Builder oAuth2Properties(Map<String, Property> oAuth2Properties) {
            this.oAuth2Properties = PropertiesMapCopier.copy(oAuth2Properties);
            return this;
        }

        public final Map<String, Property.Builder> getBasicAuthenticationProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.basicAuthenticationProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBasicAuthenticationProperties(Map<String, Property.BuilderImpl> basicAuthenticationProperties) {
            this.basicAuthenticationProperties = PropertiesMapCopier.copyFromBuilder(basicAuthenticationProperties);
        }

        @Override
        public final Builder basicAuthenticationProperties(Map<String, Property> basicAuthenticationProperties) {
            this.basicAuthenticationProperties = PropertiesMapCopier.copy(basicAuthenticationProperties);
            return this;
        }

        public final Map<String, Property.Builder> getCustomAuthenticationProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.customAuthenticationProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCustomAuthenticationProperties(Map<String, Property.BuilderImpl> customAuthenticationProperties) {
            this.customAuthenticationProperties = PropertiesMapCopier.copyFromBuilder(customAuthenticationProperties);
        }

        @Override
        public final Builder customAuthenticationProperties(Map<String, Property> customAuthenticationProperties) {
            this.customAuthenticationProperties = PropertiesMapCopier.copy(customAuthenticationProperties);
            return this;
        }

        public AuthConfiguration build() {
            return new AuthConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthConfiguration> {
        public Builder authenticationType(Property var1);

        default public Builder authenticationType(Consumer<Property.Builder> authenticationType) {
            return this.authenticationType((Property)((Property.Builder)Property.builder().applyMutation(authenticationType)).build());
        }

        public Builder secretArn(Property var1);

        default public Builder secretArn(Consumer<Property.Builder> secretArn) {
            return this.secretArn((Property)((Property.Builder)Property.builder().applyMutation(secretArn)).build());
        }

        public Builder oAuth2Properties(Map<String, Property> var1);

        public Builder basicAuthenticationProperties(Map<String, Property> var1);

        public Builder customAuthenticationProperties(Map<String, Property> var1);
    }
}

